/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSummary implements SdkPojo, Serializable, ToCopyableBuilder<DomainSummary.Builder, DomainSummary> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainSummary::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DomainSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DOMAIN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainSummary::domainStatusAsString)).setter(setter(Builder::domainStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DISPLAY_NAME_FIELD, CREATED_TIME_FIELD, DOMAIN_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String displayName;

    private final Instant createdTime;

    private final String domainStatus;

    private DomainSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.displayName = builder.displayName;
        this.createdTime = builder.createdTime;
        this.domainStatus = builder.domainStatus;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name to display.
     * </p>
     * 
     * @return The name to display.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The time that the domain was created.
     * </p>
     * 
     * @return The time that the domain was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The status of the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainStatus} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainStatusAsString}.
     * </p>
     * 
     * @return The status of the domain.
     * @see DomainStatus
     */
    public DomainStatus domainStatus() {
        return DomainStatus.fromValue(domainStatus);
    }

    /**
     * <p>
     * The status of the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainStatus} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainStatusAsString}.
     * </p>
     * 
     * @return The status of the domain.
     * @see DomainStatus
     */
    public String domainStatusAsString() {
        return domainStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(domainStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(domainStatusAsString(), other.domainStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainSummary").add("DomainName", domainName()).add("DisplayName", displayName())
                .add("CreatedTime", createdTime()).add("DomainStatus", domainStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DomainStatus":
            return Optional.ofNullable(clazz.cast(domainStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSummary, T> g) {
        return obj -> g.apply((DomainSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSummary> {
        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name to display.
         * </p>
         * 
         * @param displayName
         *        The name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The time that the domain was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The status of the domain.
         * </p>
         * 
         * @param domainStatus
         *        The status of the domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder domainStatus(String domainStatus);

        /**
         * <p>
         * The status of the domain.
         * </p>
         * 
         * @param domainStatus
         *        The status of the domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder domainStatus(DomainStatus domainStatus);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String displayName;

        private Instant createdTime;

        private String domainStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            domainName(model.domainName);
            displayName(model.displayName);
            createdTime(model.createdTime);
            domainStatus(model.domainStatus);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getDomainStatus() {
            return domainStatus;
        }

        @Override
        public final Builder domainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        @Override
        public final Builder domainStatus(DomainStatus domainStatus) {
            this.domainStatus(domainStatus == null ? null : domainStatus.toString());
            return this;
        }

        public final void setDomainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
        }

        @Override
        public DomainSummary build() {
            return new DomainSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
