/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWebsiteCertificateAuthorityResponse extends WorkLinkResponse implements
        ToCopyableBuilder<DescribeWebsiteCertificateAuthorityResponse.Builder, DescribeWebsiteCertificateAuthorityResponse> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeWebsiteCertificateAuthorityResponse::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeWebsiteCertificateAuthorityResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeWebsiteCertificateAuthorityResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD,
            CREATED_TIME_FIELD, DISPLAY_NAME_FIELD));

    private final String certificate;

    private final Instant createdTime;

    private final String displayName;

    private DescribeWebsiteCertificateAuthorityResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.createdTime = builder.createdTime;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * The root certificate of the certificate authority.
     * </p>
     * 
     * @return The root certificate of the certificate authority.
     */
    public String certificate() {
        return certificate;
    }

    /**
     * <p>
     * The time that the certificate authority was added.
     * </p>
     * 
     * @return The time that the certificate authority was added.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The certificate name to display.
     * </p>
     * 
     * @return The certificate name to display.
     */
    public String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWebsiteCertificateAuthorityResponse)) {
            return false;
        }
        DescribeWebsiteCertificateAuthorityResponse other = (DescribeWebsiteCertificateAuthorityResponse) obj;
        return Objects.equals(certificate(), other.certificate()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeWebsiteCertificateAuthorityResponse").add("Certificate", certificate())
                .add("CreatedTime", createdTime()).add("DisplayName", displayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWebsiteCertificateAuthorityResponse, T> g) {
        return obj -> g.apply((DescribeWebsiteCertificateAuthorityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWebsiteCertificateAuthorityResponse> {
        /**
         * <p>
         * The root certificate of the certificate authority.
         * </p>
         * 
         * @param certificate
         *        The root certificate of the certificate authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * The time that the certificate authority was added.
         * </p>
         * 
         * @param createdTime
         *        The time that the certificate authority was added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The certificate name to display.
         * </p>
         * 
         * @param displayName
         *        The certificate name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private String certificate;

        private Instant createdTime;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWebsiteCertificateAuthorityResponse model) {
            super(model);
            certificate(model.certificate);
            createdTime(model.createdTime);
            displayName(model.displayName);
        }

        public final String getCertificate() {
            return certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public DescribeWebsiteCertificateAuthorityResponse build() {
            return new DescribeWebsiteCertificateAuthorityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
