/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFleetMetadataRequest extends WorkLinkRequest implements
        ToCopyableBuilder<UpdateFleetMetadataRequest.Builder, UpdateFleetMetadataRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFleetMetadataRequest::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFleetMetadataRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Boolean> OPTIMIZE_FOR_END_USER_LOCATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateFleetMetadataRequest::optimizeForEndUserLocation))
            .setter(setter(Builder::optimizeForEndUserLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeForEndUserLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD,
            DISPLAY_NAME_FIELD, OPTIMIZE_FOR_END_USER_LOCATION_FIELD));

    private final String fleetArn;

    private final String displayName;

    private final Boolean optimizeForEndUserLocation;

    private UpdateFleetMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.displayName = builder.displayName;
        this.optimizeForEndUserLocation = builder.optimizeForEndUserLocation;
    }

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     * 
     * @return The ARN of the fleet.
     */
    public String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The fleet name to display. The existing DisplayName is unset if null is passed.
     * </p>
     * 
     * @return The fleet name to display. The existing DisplayName is unset if null is passed.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The option to optimize for better performance by routing traffic through the closest AWS Region to users, which
     * may be outside of your home Region.
     * </p>
     * 
     * @return The option to optimize for better performance by routing traffic through the closest AWS Region to users,
     *         which may be outside of your home Region.
     */
    public Boolean optimizeForEndUserLocation() {
        return optimizeForEndUserLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(optimizeForEndUserLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetMetadataRequest)) {
            return false;
        }
        UpdateFleetMetadataRequest other = (UpdateFleetMetadataRequest) obj;
        return Objects.equals(fleetArn(), other.fleetArn()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(optimizeForEndUserLocation(), other.optimizeForEndUserLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFleetMetadataRequest").add("FleetArn", fleetArn()).add("DisplayName", displayName())
                .add("OptimizeForEndUserLocation", optimizeForEndUserLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "OptimizeForEndUserLocation":
            return Optional.ofNullable(clazz.cast(optimizeForEndUserLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetMetadataRequest, T> g) {
        return obj -> g.apply((UpdateFleetMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFleetMetadataRequest> {
        /**
         * <p>
         * The ARN of the fleet.
         * </p>
         * 
         * @param fleetArn
         *        The ARN of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The fleet name to display. The existing DisplayName is unset if null is passed.
         * </p>
         * 
         * @param displayName
         *        The fleet name to display. The existing DisplayName is unset if null is passed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The option to optimize for better performance by routing traffic through the closest AWS Region to users,
         * which may be outside of your home Region.
         * </p>
         * 
         * @param optimizeForEndUserLocation
         *        The option to optimize for better performance by routing traffic through the closest AWS Region to
         *        users, which may be outside of your home Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizeForEndUserLocation(Boolean optimizeForEndUserLocation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkLinkRequest.BuilderImpl implements Builder {
        private String fleetArn;

        private String displayName;

        private Boolean optimizeForEndUserLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetMetadataRequest model) {
            super(model);
            fleetArn(model.fleetArn);
            displayName(model.displayName);
            optimizeForEndUserLocation(model.optimizeForEndUserLocation);
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getOptimizeForEndUserLocation() {
            return optimizeForEndUserLocation;
        }

        @Override
        public final Builder optimizeForEndUserLocation(Boolean optimizeForEndUserLocation) {
            this.optimizeForEndUserLocation = optimizeForEndUserLocation;
            return this;
        }

        public final void setOptimizeForEndUserLocation(Boolean optimizeForEndUserLocation) {
            this.optimizeForEndUserLocation = optimizeForEndUserLocation;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetMetadataRequest build() {
            return new UpdateFleetMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
