/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.worklink.model.AssociateDomainRequest;
import software.amazon.awssdk.services.worklink.model.AssociateDomainResponse;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteAuthorizationProviderRequest;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteAuthorizationProviderResponse;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.CreateFleetRequest;
import software.amazon.awssdk.services.worklink.model.CreateFleetResponse;
import software.amazon.awssdk.services.worklink.model.DeleteFleetRequest;
import software.amazon.awssdk.services.worklink.model.DeleteFleetResponse;
import software.amazon.awssdk.services.worklink.model.DescribeAuditStreamConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeAuditStreamConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeCompanyNetworkConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeCompanyNetworkConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDevicePolicyConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDevicePolicyConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDomainRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDomainResponse;
import software.amazon.awssdk.services.worklink.model.DescribeFleetMetadataRequest;
import software.amazon.awssdk.services.worklink.model.DescribeFleetMetadataResponse;
import software.amazon.awssdk.services.worklink.model.DescribeIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.DescribeWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateDomainRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateDomainResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteAuthorizationProviderRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteAuthorizationProviderResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.InternalServerErrorException;
import software.amazon.awssdk.services.worklink.model.InvalidRequestException;
import software.amazon.awssdk.services.worklink.model.ListDevicesRequest;
import software.amazon.awssdk.services.worklink.model.ListDevicesResponse;
import software.amazon.awssdk.services.worklink.model.ListDomainsRequest;
import software.amazon.awssdk.services.worklink.model.ListDomainsResponse;
import software.amazon.awssdk.services.worklink.model.ListFleetsRequest;
import software.amazon.awssdk.services.worklink.model.ListFleetsResponse;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse;
import software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.worklink.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.worklink.model.ResourceNotFoundException;
import software.amazon.awssdk.services.worklink.model.RestoreDomainAccessRequest;
import software.amazon.awssdk.services.worklink.model.RestoreDomainAccessResponse;
import software.amazon.awssdk.services.worklink.model.RevokeDomainAccessRequest;
import software.amazon.awssdk.services.worklink.model.RevokeDomainAccessResponse;
import software.amazon.awssdk.services.worklink.model.SignOutUserRequest;
import software.amazon.awssdk.services.worklink.model.SignOutUserResponse;
import software.amazon.awssdk.services.worklink.model.TooManyRequestsException;
import software.amazon.awssdk.services.worklink.model.UnauthorizedException;
import software.amazon.awssdk.services.worklink.model.UpdateAuditStreamConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateAuditStreamConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateCompanyNetworkConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateCompanyNetworkConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateDevicePolicyConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateDevicePolicyConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateDomainMetadataRequest;
import software.amazon.awssdk.services.worklink.model.UpdateDomainMetadataResponse;
import software.amazon.awssdk.services.worklink.model.UpdateFleetMetadataRequest;
import software.amazon.awssdk.services.worklink.model.UpdateFleetMetadataResponse;
import software.amazon.awssdk.services.worklink.model.UpdateIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.WorkLinkException;
import software.amazon.awssdk.services.worklink.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.worklink.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable;
import software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersIterable;
import software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesIterable;

/**
 * Service client for accessing WorkLink. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon WorkLink is a cloud-based service that provides secure access to internal websites and web apps from iOS
 * phones. In a single step, your users, such as employees, can access internal websites as efficiently as they access
 * any other public website. They enter a URL in their web browser, or choose a link to an internal website in an email.
 * Amazon WorkLink authenticates the user's access and securely renders authorized internal web content in a secure
 * rendering service in the AWS cloud. Amazon WorkLink doesn't download or store any internal web content on mobile
 * devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface WorkLinkClient extends SdkClient {
    String SERVICE_NAME = "worklink";

    /**
     * Create a {@link WorkLinkClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkLinkClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkLinkClient}.
     */
    static WorkLinkClientBuilder builder() {
        return new DefaultWorkLinkClientBuilder();
    }

    /**
     * <p>
     * Specifies a domain to be associated to Amazon WorkLink.
     * </p>
     *
     * @param associateDomainRequest
     * @return Result of the AssociateDomain operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.AssociateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateDomainResponse associateDomain(AssociateDomainRequest associateDomainRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, ResourceAlreadyExistsException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies a domain to be associated to Amazon WorkLink.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDomainRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateDomainRequest#builder()}
     * </p>
     *
     * @param associateDomainRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDomainRequest.Builder} to create a request.
     * @return Result of the AssociateDomain operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.AssociateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateDomainResponse associateDomain(Consumer<AssociateDomainRequest.Builder> associateDomainRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return associateDomain(AssociateDomainRequest.builder().applyMutation(associateDomainRequest).build());
    }

    /**
     * <p>
     * Associates a website authorization provider with a specified fleet. This is used to authorize users against
     * associated websites in the company network.
     * </p>
     *
     * @param associateWebsiteAuthorizationProviderRequest
     * @return Result of the AssociateWebsiteAuthorizationProvider operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.AssociateWebsiteAuthorizationProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteAuthorizationProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWebsiteAuthorizationProviderResponse associateWebsiteAuthorizationProvider(
            AssociateWebsiteAuthorizationProviderRequest associateWebsiteAuthorizationProviderRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a website authorization provider with a specified fleet. This is used to authorize users against
     * associated websites in the company network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWebsiteAuthorizationProviderRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWebsiteAuthorizationProviderRequest#builder()}
     * </p>
     *
     * @param associateWebsiteAuthorizationProviderRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWebsiteAuthorizationProviderRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateWebsiteAuthorizationProvider operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.AssociateWebsiteAuthorizationProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteAuthorizationProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWebsiteAuthorizationProviderResponse associateWebsiteAuthorizationProvider(
            Consumer<AssociateWebsiteAuthorizationProviderRequest.Builder> associateWebsiteAuthorizationProviderRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return associateWebsiteAuthorizationProvider(AssociateWebsiteAuthorizationProviderRequest.builder()
                .applyMutation(associateWebsiteAuthorizationProviderRequest).build());
    }

    /**
     * <p>
     * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated
     * websites within the company network.
     * </p>
     *
     * @param associateWebsiteCertificateAuthorityRequest
     * @return Result of the AssociateWebsiteCertificateAuthority operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.AssociateWebsiteCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWebsiteCertificateAuthorityResponse associateWebsiteCertificateAuthority(
            AssociateWebsiteCertificateAuthorityRequest associateWebsiteCertificateAuthorityRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated
     * websites within the company network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWebsiteCertificateAuthorityRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWebsiteCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param associateWebsiteCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWebsiteCertificateAuthorityRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateWebsiteCertificateAuthority operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.AssociateWebsiteCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateWebsiteCertificateAuthorityResponse associateWebsiteCertificateAuthority(
            Consumer<AssociateWebsiteCertificateAuthorityRequest.Builder> associateWebsiteCertificateAuthorityRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return associateWebsiteCertificateAuthority(AssociateWebsiteCertificateAuthorityRequest.builder()
                .applyMutation(associateWebsiteCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to
     * authorized users who download and set up the Amazon WorkLink app.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, ResourceAlreadyExistsException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to
     * authorized users who download and set up the Amazon WorkLink app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetRequest.Builder} to create a request.
     * @return Result of the CreateFleet operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet. Prevents users from accessing previously associated websites.
     * </p>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet. Prevents users from accessing previously associated websites.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetRequest.Builder} to create a request.
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Describes the configuration for delivering audit streams to the customer account.
     * </p>
     *
     * @param describeAuditStreamConfigurationRequest
     * @return Result of the DescribeAuditStreamConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeAuditStreamConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeAuditStreamConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAuditStreamConfigurationResponse describeAuditStreamConfiguration(
            DescribeAuditStreamConfigurationRequest describeAuditStreamConfigurationRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the configuration for delivering audit streams to the customer account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditStreamConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAuditStreamConfigurationRequest#builder()}
     * </p>
     *
     * @param describeAuditStreamConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAuditStreamConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAuditStreamConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeAuditStreamConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeAuditStreamConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAuditStreamConfigurationResponse describeAuditStreamConfiguration(
            Consumer<DescribeAuditStreamConfigurationRequest.Builder> describeAuditStreamConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return describeAuditStreamConfiguration(DescribeAuditStreamConfigurationRequest.builder()
                .applyMutation(describeAuditStreamConfigurationRequest).build());
    }

    /**
     * <p>
     * Describes the networking configuration to access the internal websites associated with the specified fleet.
     * </p>
     *
     * @param describeCompanyNetworkConfigurationRequest
     * @return Result of the DescribeCompanyNetworkConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeCompanyNetworkConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeCompanyNetworkConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCompanyNetworkConfigurationResponse describeCompanyNetworkConfiguration(
            DescribeCompanyNetworkConfigurationRequest describeCompanyNetworkConfigurationRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the networking configuration to access the internal websites associated with the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCompanyNetworkConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCompanyNetworkConfigurationRequest#builder()}
     * </p>
     *
     * @param describeCompanyNetworkConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCompanyNetworkConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeCompanyNetworkConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeCompanyNetworkConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeCompanyNetworkConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCompanyNetworkConfigurationResponse describeCompanyNetworkConfiguration(
            Consumer<DescribeCompanyNetworkConfigurationRequest.Builder> describeCompanyNetworkConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return describeCompanyNetworkConfiguration(DescribeCompanyNetworkConfigurationRequest.builder()
                .applyMutation(describeCompanyNetworkConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides information about a user's device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a user's device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeviceRequest.Builder} to create a request.
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * Describes the device policy configuration for the specified fleet.
     * </p>
     *
     * @param describeDevicePolicyConfigurationRequest
     * @return Result of the DescribeDevicePolicyConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeDevicePolicyConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevicePolicyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDevicePolicyConfigurationResponse describeDevicePolicyConfiguration(
            DescribeDevicePolicyConfigurationRequest describeDevicePolicyConfigurationRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the device policy configuration for the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDevicePolicyConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDevicePolicyConfigurationRequest#builder()}
     * </p>
     *
     * @param describeDevicePolicyConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDevicePolicyConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeDevicePolicyConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeDevicePolicyConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevicePolicyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDevicePolicyConfigurationResponse describeDevicePolicyConfiguration(
            Consumer<DescribeDevicePolicyConfigurationRequest.Builder> describeDevicePolicyConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return describeDevicePolicyConfiguration(DescribeDevicePolicyConfigurationRequest.builder()
                .applyMutation(describeDevicePolicyConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides information about the domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainRequest.Builder} to create a request.
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDomainResponse describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Provides basic information for the specified fleet, excluding identity provider, networking, and device
     * configuration details.
     * </p>
     *
     * @param describeFleetMetadataRequest
     * @return Result of the DescribeFleetMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeFleetMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeFleetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFleetMetadataResponse describeFleetMetadata(DescribeFleetMetadataRequest describeFleetMetadataRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides basic information for the specified fleet, excluding identity provider, networking, and device
     * configuration details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetMetadataRequest#builder()}
     * </p>
     *
     * @param describeFleetMetadataRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFleetMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeFleetMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeFleetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFleetMetadataResponse describeFleetMetadata(
            Consumer<DescribeFleetMetadataRequest.Builder> describeFleetMetadataRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return describeFleetMetadata(DescribeFleetMetadataRequest.builder().applyMutation(describeFleetMetadataRequest).build());
    }

    /**
     * <p>
     * Describes the identity provider configuration of the specified fleet.
     * </p>
     *
     * @param describeIdentityProviderConfigurationRequest
     * @return Result of the DescribeIdentityProviderConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeIdentityProviderConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIdentityProviderConfigurationResponse describeIdentityProviderConfiguration(
            DescribeIdentityProviderConfigurationRequest describeIdentityProviderConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the identity provider configuration of the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeIdentityProviderConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeIdentityProviderConfigurationRequest#builder()}
     * </p>
     *
     * @param describeIdentityProviderConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIdentityProviderConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeIdentityProviderConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeIdentityProviderConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIdentityProviderConfigurationResponse describeIdentityProviderConfiguration(
            Consumer<DescribeIdentityProviderConfigurationRequest.Builder> describeIdentityProviderConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return describeIdentityProviderConfiguration(DescribeIdentityProviderConfigurationRequest.builder()
                .applyMutation(describeIdentityProviderConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides information about the certificate authority.
     * </p>
     *
     * @param describeWebsiteCertificateAuthorityRequest
     * @return Result of the DescribeWebsiteCertificateAuthority operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeWebsiteCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWebsiteCertificateAuthorityResponse describeWebsiteCertificateAuthority(
            DescribeWebsiteCertificateAuthorityRequest describeWebsiteCertificateAuthorityRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the certificate authority.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWebsiteCertificateAuthorityRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWebsiteCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param describeWebsiteCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWebsiteCertificateAuthorityRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeWebsiteCertificateAuthority operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DescribeWebsiteCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWebsiteCertificateAuthorityResponse describeWebsiteCertificateAuthority(
            Consumer<DescribeWebsiteCertificateAuthorityRequest.Builder> describeWebsiteCertificateAuthorityRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return describeWebsiteCertificateAuthority(DescribeWebsiteCertificateAuthorityRequest.builder()
                .applyMutation(describeWebsiteCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon
     * WorkLink.
     * </p>
     *
     * @param disassociateDomainRequest
     * @return Result of the DisassociateDomain operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DisassociateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateDomainResponse disassociateDomain(DisassociateDomainRequest disassociateDomainRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon
     * WorkLink.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateDomainRequest#builder()}
     * </p>
     *
     * @param disassociateDomainRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDomainRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateDomain operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DisassociateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateDomainResponse disassociateDomain(Consumer<DisassociateDomainRequest.Builder> disassociateDomainRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return disassociateDomain(DisassociateDomainRequest.builder().applyMutation(disassociateDomainRequest).build());
    }

    /**
     * <p>
     * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load
     * any associated websites that require this authorization provider.
     * </p>
     *
     * @param disassociateWebsiteAuthorizationProviderRequest
     * @return Result of the DisassociateWebsiteAuthorizationProvider operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DisassociateWebsiteAuthorizationProvider
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteAuthorizationProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWebsiteAuthorizationProviderResponse disassociateWebsiteAuthorizationProvider(
            DisassociateWebsiteAuthorizationProviderRequest disassociateWebsiteAuthorizationProviderRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load
     * any associated websites that require this authorization provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWebsiteAuthorizationProviderRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWebsiteAuthorizationProviderRequest#builder()}
     * </p>
     *
     * @param disassociateWebsiteAuthorizationProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWebsiteAuthorizationProviderRequest.Builder} to create a request.
     * @return Result of the DisassociateWebsiteAuthorizationProvider operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DisassociateWebsiteAuthorizationProvider
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteAuthorizationProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWebsiteAuthorizationProviderResponse disassociateWebsiteAuthorizationProvider(
            Consumer<DisassociateWebsiteAuthorizationProviderRequest.Builder> disassociateWebsiteAuthorizationProviderRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return disassociateWebsiteAuthorizationProvider(DisassociateWebsiteAuthorizationProviderRequest.builder()
                .applyMutation(disassociateWebsiteAuthorizationProviderRequest).build());
    }

    /**
     * <p>
     * Removes a certificate authority (CA).
     * </p>
     *
     * @param disassociateWebsiteCertificateAuthorityRequest
     * @return Result of the DisassociateWebsiteCertificateAuthority operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DisassociateWebsiteCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWebsiteCertificateAuthorityResponse disassociateWebsiteCertificateAuthority(
            DisassociateWebsiteCertificateAuthorityRequest disassociateWebsiteCertificateAuthorityRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a certificate authority (CA).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWebsiteCertificateAuthorityRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWebsiteCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param disassociateWebsiteCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWebsiteCertificateAuthorityRequest.Builder} to create a request.
     * @return Result of the DisassociateWebsiteCertificateAuthority operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.DisassociateWebsiteCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateWebsiteCertificateAuthorityResponse disassociateWebsiteCertificateAuthority(
            Consumer<DisassociateWebsiteCertificateAuthorityRequest.Builder> disassociateWebsiteCertificateAuthorityRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return disassociateWebsiteCertificateAuthority(DisassociateWebsiteCertificateAuthorityRequest.builder()
                .applyMutation(disassociateWebsiteCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of devices registered with the specified fleet.
     * </p>
     *
     * @param listDevicesRequest
     * @return Result of the ListDevices operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of devices registered with the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesRequest.Builder} to create a request.
     * @return Result of the ListDevices operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of devices registered with the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.worklink.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.worklink.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator(ListDevicesRequest listDevicesRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of devices registered with the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.worklink.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.worklink.model.ListDevicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator(Consumer<ListDevicesRequest.Builder> listDevicesRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return listDevicesPaginator(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of domains associated to a specified fleet.
     * </p>
     *
     * @param listDomainsRequest
     * @return Result of the ListDomains operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of domains associated to a specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return Result of the ListDomains operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsResponse listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of domains associated to a specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.worklink.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.worklink.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of domains associated to a specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.worklink.model.ListDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDomainsIterable responses = client.listDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.worklink.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsIterable listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     *
     * @return Result of the ListFleets operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListFleets
     * @see #listFleets(ListFleetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets() throws UnauthorizedException, InternalServerErrorException, InvalidRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return listFleets(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     *
     * @param listFleetsRequest
     * @return Result of the ListFleets operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsRequest.Builder} to create a request.
     * @return Result of the ListFleets operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, WorkLinkException {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListFleets
     * @see #listFleetsPaginator(ListFleetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator() throws UnauthorizedException, InternalServerErrorException,
            InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return listFleetsPaginator(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(ListFleetsRequest listFleetsRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of website authorization providers associated with a specified fleet.
     * </p>
     *
     * @param listWebsiteAuthorizationProvidersRequest
     * @return Result of the ListWebsiteAuthorizationProviders operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListWebsiteAuthorizationProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWebsiteAuthorizationProvidersResponse listWebsiteAuthorizationProviders(
            ListWebsiteAuthorizationProvidersRequest listWebsiteAuthorizationProvidersRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of website authorization providers associated with a specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebsiteAuthorizationProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListWebsiteAuthorizationProvidersRequest#builder()}
     * </p>
     *
     * @param listWebsiteAuthorizationProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListWebsiteAuthorizationProvidersRequest.Builder} to
     *        create a request.
     * @return Result of the ListWebsiteAuthorizationProviders operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListWebsiteAuthorizationProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWebsiteAuthorizationProvidersResponse listWebsiteAuthorizationProviders(
            Consumer<ListWebsiteAuthorizationProvidersRequest.Builder> listWebsiteAuthorizationProvidersRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return listWebsiteAuthorizationProviders(ListWebsiteAuthorizationProvidersRequest.builder()
                .applyMutation(listWebsiteAuthorizationProvidersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of website authorization providers associated with a specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWebsiteAuthorizationProviders(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersIterable responses = client.listWebsiteAuthorizationProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersIterable responses = client
     *             .listWebsiteAuthorizationProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersIterable responses = client.listWebsiteAuthorizationProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebsiteAuthorizationProviders(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWebsiteAuthorizationProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListWebsiteAuthorizationProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWebsiteAuthorizationProvidersIterable listWebsiteAuthorizationProvidersPaginator(
            ListWebsiteAuthorizationProvidersRequest listWebsiteAuthorizationProvidersRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of website authorization providers associated with a specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWebsiteAuthorizationProviders(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersIterable responses = client.listWebsiteAuthorizationProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersIterable responses = client
     *             .listWebsiteAuthorizationProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersIterable responses = client.listWebsiteAuthorizationProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebsiteAuthorizationProviders(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebsiteAuthorizationProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListWebsiteAuthorizationProvidersRequest#builder()}
     * </p>
     *
     * @param listWebsiteAuthorizationProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListWebsiteAuthorizationProvidersRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListWebsiteAuthorizationProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWebsiteAuthorizationProvidersIterable listWebsiteAuthorizationProvidersPaginator(
            Consumer<ListWebsiteAuthorizationProvidersRequest.Builder> listWebsiteAuthorizationProvidersRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return listWebsiteAuthorizationProvidersPaginator(ListWebsiteAuthorizationProvidersRequest.builder()
                .applyMutation(listWebsiteAuthorizationProvidersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of certificate authorities added for the current account and Region.
     * </p>
     *
     * @param listWebsiteCertificateAuthoritiesRequest
     * @return Result of the ListWebsiteCertificateAuthorities operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListWebsiteCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWebsiteCertificateAuthoritiesResponse listWebsiteCertificateAuthorities(
            ListWebsiteCertificateAuthoritiesRequest listWebsiteCertificateAuthoritiesRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of certificate authorities added for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebsiteCertificateAuthoritiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListWebsiteCertificateAuthoritiesRequest#builder()}
     * </p>
     *
     * @param listWebsiteCertificateAuthoritiesRequest
     *        A {@link Consumer} that will call methods on {@link ListWebsiteCertificateAuthoritiesRequest.Builder} to
     *        create a request.
     * @return Result of the ListWebsiteCertificateAuthorities operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListWebsiteCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWebsiteCertificateAuthoritiesResponse listWebsiteCertificateAuthorities(
            Consumer<ListWebsiteCertificateAuthoritiesRequest.Builder> listWebsiteCertificateAuthoritiesRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return listWebsiteCertificateAuthorities(ListWebsiteCertificateAuthoritiesRequest.builder()
                .applyMutation(listWebsiteCertificateAuthoritiesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of certificate authorities added for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWebsiteCertificateAuthorities(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesIterable responses = client.listWebsiteCertificateAuthoritiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesIterable responses = client
     *             .listWebsiteCertificateAuthoritiesPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesIterable responses = client.listWebsiteCertificateAuthoritiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebsiteCertificateAuthorities(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWebsiteCertificateAuthoritiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListWebsiteCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWebsiteCertificateAuthoritiesIterable listWebsiteCertificateAuthoritiesPaginator(
            ListWebsiteCertificateAuthoritiesRequest listWebsiteCertificateAuthoritiesRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of certificate authorities added for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWebsiteCertificateAuthorities(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesIterable responses = client.listWebsiteCertificateAuthoritiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesIterable responses = client
     *             .listWebsiteCertificateAuthoritiesPaginator(request);
     *     for (software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesIterable responses = client.listWebsiteCertificateAuthoritiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebsiteCertificateAuthorities(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebsiteCertificateAuthoritiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListWebsiteCertificateAuthoritiesRequest#builder()}
     * </p>
     *
     * @param listWebsiteCertificateAuthoritiesRequest
     *        A {@link Consumer} that will call methods on {@link ListWebsiteCertificateAuthoritiesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.ListWebsiteCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWebsiteCertificateAuthoritiesIterable listWebsiteCertificateAuthoritiesPaginator(
            Consumer<ListWebsiteCertificateAuthoritiesRequest.Builder> listWebsiteCertificateAuthoritiesRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return listWebsiteCertificateAuthoritiesPaginator(ListWebsiteCertificateAuthoritiesRequest.builder()
                .applyMutation(listWebsiteCertificateAuthoritiesRequest).build());
    }

    /**
     * <p>
     * Moves a domain to ACTIVE status if it was in the INACTIVE status.
     * </p>
     *
     * @param restoreDomainAccessRequest
     * @return Result of the RestoreDomainAccess operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.RestoreDomainAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RestoreDomainAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default RestoreDomainAccessResponse restoreDomainAccess(RestoreDomainAccessRequest restoreDomainAccessRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a domain to ACTIVE status if it was in the INACTIVE status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDomainAccessRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreDomainAccessRequest#builder()}
     * </p>
     *
     * @param restoreDomainAccessRequest
     *        A {@link Consumer} that will call methods on {@link RestoreDomainAccessRequest.Builder} to create a
     *        request.
     * @return Result of the RestoreDomainAccess operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.RestoreDomainAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RestoreDomainAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default RestoreDomainAccessResponse restoreDomainAccess(
            Consumer<RestoreDomainAccessRequest.Builder> restoreDomainAccessRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return restoreDomainAccess(RestoreDomainAccessRequest.builder().applyMutation(restoreDomainAccessRequest).build());
    }

    /**
     * <p>
     * Moves a domain to INACTIVE status if it was in the ACTIVE status.
     * </p>
     *
     * @param revokeDomainAccessRequest
     * @return Result of the RevokeDomainAccess operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.RevokeDomainAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RevokeDomainAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default RevokeDomainAccessResponse revokeDomainAccess(RevokeDomainAccessRequest revokeDomainAccessRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a domain to INACTIVE status if it was in the ACTIVE status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeDomainAccessRequest.Builder} avoiding the
     * need to create one manually via {@link RevokeDomainAccessRequest#builder()}
     * </p>
     *
     * @param revokeDomainAccessRequest
     *        A {@link Consumer} that will call methods on {@link RevokeDomainAccessRequest.Builder} to create a
     *        request.
     * @return Result of the RevokeDomainAccess operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.RevokeDomainAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RevokeDomainAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default RevokeDomainAccessResponse revokeDomainAccess(Consumer<RevokeDomainAccessRequest.Builder> revokeDomainAccessRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return revokeDomainAccess(RevokeDomainAccessRequest.builder().applyMutation(revokeDomainAccessRequest).build());
    }

    /**
     * <p>
     * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
     * </p>
     *
     * @param signOutUserRequest
     * @return Result of the SignOutUser operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.SignOutUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/SignOutUser" target="_top">AWS API
     *      Documentation</a>
     */
    default SignOutUserResponse signOutUser(SignOutUserRequest signOutUserRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignOutUserRequest.Builder} avoiding the need to
     * create one manually via {@link SignOutUserRequest#builder()}
     * </p>
     *
     * @param signOutUserRequest
     *        A {@link Consumer} that will call methods on {@link SignOutUserRequest.Builder} to create a request.
     * @return Result of the SignOutUser operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.SignOutUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/SignOutUser" target="_top">AWS API
     *      Documentation</a>
     */
    default SignOutUserResponse signOutUser(Consumer<SignOutUserRequest.Builder> signOutUserRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return signOutUser(SignOutUserRequest.builder().applyMutation(signOutUserRequest).build());
    }

    /**
     * <p>
     * Updates the audit stream configuration for the fleet.
     * </p>
     *
     * @param updateAuditStreamConfigurationRequest
     * @return Result of the UpdateAuditStreamConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateAuditStreamConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateAuditStreamConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAuditStreamConfigurationResponse updateAuditStreamConfiguration(
            UpdateAuditStreamConfigurationRequest updateAuditStreamConfigurationRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the audit stream configuration for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuditStreamConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAuditStreamConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAuditStreamConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAuditStreamConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAuditStreamConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateAuditStreamConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateAuditStreamConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAuditStreamConfigurationResponse updateAuditStreamConfiguration(
            Consumer<UpdateAuditStreamConfigurationRequest.Builder> updateAuditStreamConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return updateAuditStreamConfiguration(UpdateAuditStreamConfigurationRequest.builder()
                .applyMutation(updateAuditStreamConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the company network configuration for the fleet.
     * </p>
     *
     * @param updateCompanyNetworkConfigurationRequest
     * @return Result of the UpdateCompanyNetworkConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateCompanyNetworkConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateCompanyNetworkConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCompanyNetworkConfigurationResponse updateCompanyNetworkConfiguration(
            UpdateCompanyNetworkConfigurationRequest updateCompanyNetworkConfigurationRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the company network configuration for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCompanyNetworkConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCompanyNetworkConfigurationRequest#builder()}
     * </p>
     *
     * @param updateCompanyNetworkConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCompanyNetworkConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCompanyNetworkConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateCompanyNetworkConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateCompanyNetworkConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCompanyNetworkConfigurationResponse updateCompanyNetworkConfiguration(
            Consumer<UpdateCompanyNetworkConfigurationRequest.Builder> updateCompanyNetworkConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return updateCompanyNetworkConfiguration(UpdateCompanyNetworkConfigurationRequest.builder()
                .applyMutation(updateCompanyNetworkConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the device policy configuration for the fleet.
     * </p>
     *
     * @param updateDevicePolicyConfigurationRequest
     * @return Result of the UpdateDevicePolicyConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateDevicePolicyConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDevicePolicyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDevicePolicyConfigurationResponse updateDevicePolicyConfiguration(
            UpdateDevicePolicyConfigurationRequest updateDevicePolicyConfigurationRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device policy configuration for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDevicePolicyConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDevicePolicyConfigurationRequest#builder()}
     * </p>
     *
     * @param updateDevicePolicyConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDevicePolicyConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDevicePolicyConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateDevicePolicyConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDevicePolicyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDevicePolicyConfigurationResponse updateDevicePolicyConfiguration(
            Consumer<UpdateDevicePolicyConfigurationRequest.Builder> updateDevicePolicyConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return updateDevicePolicyConfiguration(UpdateDevicePolicyConfigurationRequest.builder()
                .applyMutation(updateDevicePolicyConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates domain metadata, such as DisplayName.
     * </p>
     *
     * @param updateDomainMetadataRequest
     * @return Result of the UpdateDomainMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateDomainMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDomainMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDomainMetadataResponse updateDomainMetadata(UpdateDomainMetadataRequest updateDomainMetadataRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates domain metadata, such as DisplayName.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDomainMetadataRequest#builder()}
     * </p>
     *
     * @param updateDomainMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDomainMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateDomainMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDomainMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDomainMetadataResponse updateDomainMetadata(
            Consumer<UpdateDomainMetadataRequest.Builder> updateDomainMetadataRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return updateDomainMetadata(UpdateDomainMetadataRequest.builder().applyMutation(updateDomainMetadataRequest).build());
    }

    /**
     * <p>
     * Updates fleet metadata, such as DisplayName.
     * </p>
     *
     * @param updateFleetMetadataRequest
     * @return Result of the UpdateFleetMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateFleetMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateFleetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFleetMetadataResponse updateFleetMetadata(UpdateFleetMetadataRequest updateFleetMetadataRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates fleet metadata, such as DisplayName.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFleetMetadataRequest#builder()}
     * </p>
     *
     * @param updateFleetMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFleetMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFleetMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateFleetMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateFleetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFleetMetadataResponse updateFleetMetadata(
            Consumer<UpdateFleetMetadataRequest.Builder> updateFleetMetadataRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        return updateFleetMetadata(UpdateFleetMetadataRequest.builder().applyMutation(updateFleetMetadataRequest).build());
    }

    /**
     * <p>
     * Updates the identity provider configuration for the fleet.
     * </p>
     *
     * @param updateIdentityProviderConfigurationRequest
     * @return Result of the UpdateIdentityProviderConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateIdentityProviderConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIdentityProviderConfigurationResponse updateIdentityProviderConfiguration(
            UpdateIdentityProviderConfigurationRequest updateIdentityProviderConfigurationRequest) throws UnauthorizedException,
            InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, WorkLinkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the identity provider configuration for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateIdentityProviderConfigurationRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIdentityProviderConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateIdentityProviderConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this action.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The requested resource was not found.
     * @throws TooManyRequestsException
     *         The number of requests exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkLinkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkLinkClient.UpdateIdentityProviderConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIdentityProviderConfigurationResponse updateIdentityProviderConfiguration(
            Consumer<UpdateIdentityProviderConfigurationRequest.Builder> updateIdentityProviderConfigurationRequest)
            throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return updateIdentityProviderConfiguration(UpdateIdentityProviderConfigurationRequest.builder()
                .applyMutation(updateIdentityProviderConfigurationRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("worklink");
    }
}
