/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.ResourcePathComponent;
import software.amazon.awssdk.services.workdocs.model.ResourcePathComponentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcePath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcePath> {
    private static final SdkField<List<ResourcePathComponent>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Components").getter(ResourcePath.getter(ResourcePath::components)).setter(ResourcePath.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Components").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePathComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourcePath.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ResourcePathComponent> components;

    private ResourcePath(BuilderImpl builder) {
        this.components = builder.components;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructList);
    }

    public final List<ResourcePathComponent> components() {
        return this.components;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        return this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcePath").add("Components", this.hasComponents() ? this.components() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ResourcePathComponent>>> map = new HashMap<String, SdkField<List<ResourcePathComponent>>>();
        map.put("Components", COMPONENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcePath, T> g) {
        return obj -> g.apply((ResourcePath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourcePathComponent> components = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePath model) {
            this.components(model.components);
        }

        public final List<ResourcePathComponent.Builder> getComponents() {
            List<ResourcePathComponent.Builder> result = ResourcePathComponentListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<ResourcePathComponent.BuilderImpl> components) {
            this.components = ResourcePathComponentListCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Collection<ResourcePathComponent> components) {
            this.components = ResourcePathComponentListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ResourcePathComponent ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<ResourcePathComponent.Builder> ... components) {
            this.components(Stream.of(components).map(c -> (ResourcePathComponent)((ResourcePathComponent.Builder)ResourcePathComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourcePath build() {
            return new ResourcePath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcePath> {
        public Builder components(Collection<ResourcePathComponent> var1);

        public Builder components(ResourcePathComponent ... var1);

        public Builder components(Consumer<ResourcePathComponent.Builder> ... var1);
    }
}

