/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.CommentStatusType;
import software.amazon.awssdk.services.workdocs.model.CommentVisibilityType;
import software.amazon.awssdk.services.workdocs.model.User;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Comment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Comment> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommentId").getter(Comment.getter(Comment::commentId)).setter(Comment.setter(Builder::commentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentId").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentId").getter(Comment.getter(Comment::parentId)).setter(Comment.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<String> THREAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThreadId").getter(Comment.getter(Comment::threadId)).setter(Comment.setter(Builder::threadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadId").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(Comment.getter(Comment::text)).setter(Comment.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<User> CONTRIBUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Contributor").getter(Comment.getter(Comment::contributor)).setter(Comment.setter(Builder::contributor)).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contributor").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(Comment.getter(Comment::createdTimestamp)).setter(Comment.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Comment.getter(Comment::statusAsString)).setter(Comment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(Comment.getter(Comment::visibilityAsString)).setter(Comment.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> RECIPIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecipientId").getter(Comment.getter(Comment::recipientId)).setter(Comment.setter(Builder::recipientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipientId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD, PARENT_ID_FIELD, THREAD_ID_FIELD, TEXT_FIELD, CONTRIBUTOR_FIELD, CREATED_TIMESTAMP_FIELD, STATUS_FIELD, VISIBILITY_FIELD, RECIPIENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Comment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String commentId;
    private final String parentId;
    private final String threadId;
    private final String text;
    private final User contributor;
    private final Instant createdTimestamp;
    private final String status;
    private final String visibility;
    private final String recipientId;

    private Comment(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.parentId = builder.parentId;
        this.threadId = builder.threadId;
        this.text = builder.text;
        this.contributor = builder.contributor;
        this.createdTimestamp = builder.createdTimestamp;
        this.status = builder.status;
        this.visibility = builder.visibility;
        this.recipientId = builder.recipientId;
    }

    public final String commentId() {
        return this.commentId;
    }

    public final String parentId() {
        return this.parentId;
    }

    public final String threadId() {
        return this.threadId;
    }

    public final String text() {
        return this.text;
    }

    public final User contributor() {
        return this.contributor;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final CommentStatusType status() {
        return CommentStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CommentVisibilityType visibility() {
        return CommentVisibilityType.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final String recipientId() {
        return this.recipientId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributor());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipientId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)obj;
        return Objects.equals(this.commentId(), other.commentId()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.threadId(), other.threadId()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.contributor(), other.contributor()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.recipientId(), other.recipientId());
    }

    public final String toString() {
        return ToString.builder((String)"Comment").add("CommentId", (Object)this.commentId()).add("ParentId", (Object)this.parentId()).add("ThreadId", (Object)this.threadId()).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("Contributor", (Object)this.contributor()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("Status", (Object)this.statusAsString()).add("Visibility", (Object)this.visibilityAsString()).add("RecipientId", (Object)this.recipientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommentId": {
                return Optional.ofNullable(clazz.cast(this.commentId()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "ThreadId": {
                return Optional.ofNullable(clazz.cast(this.threadId()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Contributor": {
                return Optional.ofNullable(clazz.cast(this.contributor()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "RecipientId": {
                return Optional.ofNullable(clazz.cast(this.recipientId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CommentId", COMMENT_ID_FIELD);
        map.put("ParentId", PARENT_ID_FIELD);
        map.put("ThreadId", THREAD_ID_FIELD);
        map.put("Text", TEXT_FIELD);
        map.put("Contributor", CONTRIBUTOR_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("RecipientId", RECIPIENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Comment, T> g) {
        return obj -> g.apply((Comment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commentId;
        private String parentId;
        private String threadId;
        private String text;
        private User contributor;
        private Instant createdTimestamp;
        private String status;
        private String visibility;
        private String recipientId;

        private BuilderImpl() {
        }

        private BuilderImpl(Comment model) {
            this.commentId(model.commentId);
            this.parentId(model.parentId);
            this.threadId(model.threadId);
            this.text(model.text);
            this.contributor(model.contributor);
            this.createdTimestamp(model.createdTimestamp);
            this.status(model.status);
            this.visibility(model.visibility);
            this.recipientId(model.recipientId);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final String getParentId() {
            return this.parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getThreadId() {
            return this.threadId;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        @Override
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final User.Builder getContributor() {
            return this.contributor != null ? this.contributor.toBuilder() : null;
        }

        public final void setContributor(User.BuilderImpl contributor) {
            this.contributor = contributor != null ? contributor.build() : null;
        }

        @Override
        public final Builder contributor(User contributor) {
            this.contributor = contributor;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommentStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(CommentVisibilityType visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getRecipientId() {
            return this.recipientId;
        }

        public final void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        @Override
        public final Builder recipientId(String recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        public Comment build() {
            return new Comment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Comment> {
        public Builder commentId(String var1);

        public Builder parentId(String var1);

        public Builder threadId(String var1);

        public Builder text(String var1);

        public Builder contributor(User var1);

        default public Builder contributor(Consumer<User.Builder> contributor) {
            return this.contributor((User)((User.Builder)User.builder().applyMutation(contributor)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(CommentStatusType var1);

        public Builder visibility(String var1);

        public Builder visibility(CommentVisibilityType var1);

        public Builder recipientId(String var1);
    }
}

