/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.LocaleType;
import software.amazon.awssdk.services.workdocs.model.UserStatusType;
import software.amazon.awssdk.services.workdocs.model.UserStorageMetadata;
import software.amazon.awssdk.services.workdocs.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(User.getter(User::id)).setter(User.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(User.getter(User::username)).setter(User.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(User.getter(User::emailAddress)).setter(User.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GivenName").getter(User.getter(User::givenName)).setter(User.setter(Builder::givenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()}).build();
    private static final SdkField<String> SURNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Surname").getter(User.getter(User::surname)).setter(User.setter(Builder::surname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(User.getter(User::organizationId)).setter(User.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> ROOT_FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootFolderId").getter(User.getter(User::rootFolderId)).setter(User.setter(Builder::rootFolderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootFolderId").build()}).build();
    private static final SdkField<String> RECYCLE_BIN_FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecycleBinFolderId").getter(User.getter(User::recycleBinFolderId)).setter(User.setter(Builder::recycleBinFolderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinFolderId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(User.getter(User::statusAsString)).setter(User.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(User.getter(User::typeAsString)).setter(User.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(User.getter(User::createdTimestamp)).setter(User.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedTimestamp").getter(User.getter(User::modifiedTimestamp)).setter(User.setter(Builder::modifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimestamp").build()}).build();
    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZoneId").getter(User.getter(User::timeZoneId)).setter(User.setter(Builder::timeZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(User.getter(User::localeAsString)).setter(User.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<UserStorageMetadata> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Storage").getter(User.getter(User::storage)).setter(User.setter(Builder::storage)).constructor(UserStorageMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Storage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, USERNAME_FIELD, EMAIL_ADDRESS_FIELD, GIVEN_NAME_FIELD, SURNAME_FIELD, ORGANIZATION_ID_FIELD, ROOT_FOLDER_ID_FIELD, RECYCLE_BIN_FOLDER_ID_FIELD, STATUS_FIELD, TYPE_FIELD, CREATED_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD, TIME_ZONE_ID_FIELD, LOCALE_FIELD, STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Username", USERNAME_FIELD);
            this.put("EmailAddress", EMAIL_ADDRESS_FIELD);
            this.put("GivenName", GIVEN_NAME_FIELD);
            this.put("Surname", SURNAME_FIELD);
            this.put("OrganizationId", ORGANIZATION_ID_FIELD);
            this.put("RootFolderId", ROOT_FOLDER_ID_FIELD);
            this.put("RecycleBinFolderId", RECYCLE_BIN_FOLDER_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("ModifiedTimestamp", MODIFIED_TIMESTAMP_FIELD);
            this.put("TimeZoneId", TIME_ZONE_ID_FIELD);
            this.put("Locale", LOCALE_FIELD);
            this.put("Storage", STORAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String username;
    private final String emailAddress;
    private final String givenName;
    private final String surname;
    private final String organizationId;
    private final String rootFolderId;
    private final String recycleBinFolderId;
    private final String status;
    private final String type;
    private final Instant createdTimestamp;
    private final Instant modifiedTimestamp;
    private final String timeZoneId;
    private final String locale;
    private final UserStorageMetadata storage;

    private User(BuilderImpl builder) {
        this.id = builder.id;
        this.username = builder.username;
        this.emailAddress = builder.emailAddress;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.organizationId = builder.organizationId;
        this.rootFolderId = builder.rootFolderId;
        this.recycleBinFolderId = builder.recycleBinFolderId;
        this.status = builder.status;
        this.type = builder.type;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.timeZoneId = builder.timeZoneId;
        this.locale = builder.locale;
        this.storage = builder.storage;
    }

    public final String id() {
        return this.id;
    }

    public final String username() {
        return this.username;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String givenName() {
        return this.givenName;
    }

    public final String surname() {
        return this.surname;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String rootFolderId() {
        return this.rootFolderId;
    }

    public final String recycleBinFolderId() {
        return this.recycleBinFolderId;
    }

    public final UserStatusType status() {
        return UserStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final UserType type() {
        return UserType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public final String timeZoneId() {
        return this.timeZoneId;
    }

    public final LocaleType locale() {
        return LocaleType.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    public final UserStorageMetadata storage() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recycleBinFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.rootFolderId(), other.rootFolderId()) && Objects.equals(this.recycleBinFolderId(), other.recycleBinFolderId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.modifiedTimestamp(), other.modifiedTimestamp()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.storage(), other.storage());
    }

    public final String toString() {
        return ToString.builder((String)"User").add("Id", (Object)this.id()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("GivenName", (Object)(this.givenName() == null ? null : "*** Sensitive Data Redacted ***")).add("Surname", (Object)(this.surname() == null ? null : "*** Sensitive Data Redacted ***")).add("OrganizationId", (Object)this.organizationId()).add("RootFolderId", (Object)this.rootFolderId()).add("RecycleBinFolderId", (Object)this.recycleBinFolderId()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("ModifiedTimestamp", (Object)this.modifiedTimestamp()).add("TimeZoneId", (Object)this.timeZoneId()).add("Locale", (Object)this.localeAsString()).add("Storage", (Object)this.storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "Surname": {
                return Optional.ofNullable(clazz.cast(this.surname()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "RootFolderId": {
                return Optional.ofNullable(clazz.cast(this.rootFolderId()));
            }
            case "RecycleBinFolderId": {
                return Optional.ofNullable(clazz.cast(this.recycleBinFolderId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "ModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.modifiedTimestamp()));
            }
            case "TimeZoneId": {
                return Optional.ofNullable(clazz.cast(this.timeZoneId()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "Storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String username;
        private String emailAddress;
        private String givenName;
        private String surname;
        private String organizationId;
        private String rootFolderId;
        private String recycleBinFolderId;
        private String status;
        private String type;
        private Instant createdTimestamp;
        private Instant modifiedTimestamp;
        private String timeZoneId;
        private String locale;
        private UserStorageMetadata storage;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.id(model.id);
            this.username(model.username);
            this.emailAddress(model.emailAddress);
            this.givenName(model.givenName);
            this.surname(model.surname);
            this.organizationId(model.organizationId);
            this.rootFolderId(model.rootFolderId);
            this.recycleBinFolderId(model.recycleBinFolderId);
            this.status(model.status);
            this.type(model.type);
            this.createdTimestamp(model.createdTimestamp);
            this.modifiedTimestamp(model.modifiedTimestamp);
            this.timeZoneId(model.timeZoneId);
            this.locale(model.locale);
            this.storage(model.storage);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getSurname() {
            return this.surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getRootFolderId() {
            return this.rootFolderId;
        }

        public final void setRootFolderId(String rootFolderId) {
            this.rootFolderId = rootFolderId;
        }

        @Override
        public final Builder rootFolderId(String rootFolderId) {
            this.rootFolderId = rootFolderId;
            return this;
        }

        public final String getRecycleBinFolderId() {
            return this.recycleBinFolderId;
        }

        public final void setRecycleBinFolderId(String recycleBinFolderId) {
            this.recycleBinFolderId = recycleBinFolderId;
        }

        @Override
        public final Builder recycleBinFolderId(String recycleBinFolderId) {
            this.recycleBinFolderId = recycleBinFolderId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleType locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final UserStorageMetadata.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        public final void setStorage(UserStorageMetadata.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(UserStorageMetadata storage) {
            this.storage = storage;
            return this;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder id(String var1);

        public Builder username(String var1);

        public Builder emailAddress(String var1);

        public Builder givenName(String var1);

        public Builder surname(String var1);

        public Builder organizationId(String var1);

        public Builder rootFolderId(String var1);

        public Builder recycleBinFolderId(String var1);

        public Builder status(String var1);

        public Builder status(UserStatusType var1);

        public Builder type(String var1);

        public Builder type(UserType var1);

        public Builder createdTimestamp(Instant var1);

        public Builder modifiedTimestamp(Instant var1);

        public Builder timeZoneId(String var1);

        public Builder locale(String var1);

        public Builder locale(LocaleType var1);

        public Builder storage(UserStorageMetadata var1);

        default public Builder storage(Consumer<UserStorageMetadata.Builder> storage) {
            return this.storage((UserStorageMetadata)((UserStorageMetadata.Builder)UserStorageMetadata.builder().applyMutation(storage)).build());
        }
    }
}

