/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FolderContentType {
    ALL("ALL"),
    DOCUMENT("DOCUMENT"),
    FOLDER("FOLDER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FolderContentType> VALUE_MAP;
    private final String value;

    private FolderContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FolderContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FolderContentType> knownValues() {
        EnumSet<FolderContentType> knownValues = EnumSet.allOf(FolderContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FolderContentType.class, FolderContentType::toString);
    }
}

