/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.workdocs.DefaultWorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.DefaultWorkDocsBaseClientBuilder;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClientBuilder;
import software.amazon.awssdk.services.workdocs.WorkDocsServiceClientConfiguration;
import software.amazon.awssdk.services.workdocs.endpoints.WorkDocsEndpointProvider;

@SdkInternalApi
final class DefaultWorkDocsAsyncClientBuilder
extends DefaultWorkDocsBaseClientBuilder<WorkDocsAsyncClientBuilder, WorkDocsAsyncClient>
implements WorkDocsAsyncClientBuilder {
    DefaultWorkDocsAsyncClientBuilder() {
    }

    @Override
    public DefaultWorkDocsAsyncClientBuilder endpointProvider(WorkDocsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkDocsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultWorkDocsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        WorkDocsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWorkDocsAsyncClient client = new DefaultWorkDocsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WorkDocsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WorkDocsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

