/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDocumentRequest extends WorkDocsRequest implements
        ToCopyableBuilder<UpdateDocumentRequest.Builder, UpdateDocumentRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(UpdateDocumentRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(UpdateDocumentRequest::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DocumentId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDocumentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PARENT_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentFolderId").getter(getter(UpdateDocumentRequest::parentFolderId))
            .setter(setter(Builder::parentFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderId").build()).build();

    private static final SdkField<String> RESOURCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceState").getter(getter(UpdateDocumentRequest::resourceStateAsString))
            .setter(setter(Builder::resourceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            DOCUMENT_ID_FIELD, NAME_FIELD, PARENT_FOLDER_ID_FIELD, RESOURCE_STATE_FIELD));

    private final String authenticationToken;

    private final String documentId;

    private final String name;

    private final String parentFolderId;

    private final String resourceState;

    private UpdateDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.name = builder.name;
        this.parentFolderId = builder.parentFolderId;
        this.resourceState = builder.resourceState;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the document.
     * </p>
     * 
     * @return The ID of the document.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The name of the document.
     * </p>
     * 
     * @return The name of the document.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the parent folder.
     * </p>
     * 
     * @return The ID of the parent folder.
     */
    public final String parentFolderId() {
        return parentFolderId;
    }

    /**
     * <p>
     * The resource state of the document. Only ACTIVE and RECYCLED are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceState}
     * will return {@link ResourceStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStateAsString}.
     * </p>
     * 
     * @return The resource state of the document. Only ACTIVE and RECYCLED are supported.
     * @see ResourceStateType
     */
    public final ResourceStateType resourceState() {
        return ResourceStateType.fromValue(resourceState);
    }

    /**
     * <p>
     * The resource state of the document. Only ACTIVE and RECYCLED are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceState}
     * will return {@link ResourceStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStateAsString}.
     * </p>
     * 
     * @return The resource state of the document. Only ACTIVE and RECYCLED are supported.
     * @see ResourceStateType
     */
    public final String resourceStateAsString() {
        return resourceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentRequest)) {
            return false;
        }
        UpdateDocumentRequest other = (UpdateDocumentRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(documentId(), other.documentId()) && Objects.equals(name(), other.name())
                && Objects.equals(parentFolderId(), other.parentFolderId())
                && Objects.equals(resourceStateAsString(), other.resourceStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDocumentRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentId", documentId()).add("Name", name()).add("ParentFolderId", parentFolderId())
                .add("ResourceState", resourceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ParentFolderId":
            return Optional.ofNullable(clazz.cast(parentFolderId()));
        case "ResourceState":
            return Optional.ofNullable(clazz.cast(resourceStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDocumentRequest, T> g) {
        return obj -> g.apply((UpdateDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDocumentRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the document.
         * </p>
         * 
         * @param documentId
         *        The ID of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The name of the document.
         * </p>
         * 
         * @param name
         *        The name of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the parent folder.
         * </p>
         * 
         * @param parentFolderId
         *        The ID of the parent folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFolderId(String parentFolderId);

        /**
         * <p>
         * The resource state of the document. Only ACTIVE and RECYCLED are supported.
         * </p>
         * 
         * @param resourceState
         *        The resource state of the document. Only ACTIVE and RECYCLED are supported.
         * @see ResourceStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStateType
         */
        Builder resourceState(String resourceState);

        /**
         * <p>
         * The resource state of the document. Only ACTIVE and RECYCLED are supported.
         * </p>
         * 
         * @param resourceState
         *        The resource state of the document. Only ACTIVE and RECYCLED are supported.
         * @see ResourceStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStateType
         */
        Builder resourceState(ResourceStateType resourceState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String documentId;

        private String name;

        private String parentFolderId;

        private String resourceState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            documentId(model.documentId);
            name(model.name);
            parentFolderId(model.parentFolderId);
            resourceState(model.resourceState);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getParentFolderId() {
            return parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public final String getResourceState() {
            return resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState == null ? null : resourceState.toString());
            return this;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDocumentRequest build() {
            return new UpdateDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
