/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCommentsResponse extends WorkDocsResponse implements
        ToCopyableBuilder<DescribeCommentsResponse.Builder, DescribeCommentsResponse> {
    private static final SdkField<List<Comment>> COMMENTS_FIELD = SdkField
            .<List<Comment>> builder(MarshallingType.LIST)
            .memberName("Comments")
            .getter(getter(DescribeCommentsResponse::comments))
            .setter(setter(Builder::comments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Comment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Comment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeCommentsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENTS_FIELD, MARKER_FIELD));

    private final List<Comment> comments;

    private final String marker;

    private DescribeCommentsResponse(BuilderImpl builder) {
        super(builder);
        this.comments = builder.comments;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the Comments property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasComments() {
        return comments != null && !(comments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of comments for the specified document version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of comments for the specified document version.
     */
    public final List<Comment> comments() {
        return comments;
    }

    /**
     * <p>
     * The marker for the next set of results. This marker was received from a previous call.
     * </p>
     * 
     * @return The marker for the next set of results. This marker was received from a previous call.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComments() ? comments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommentsResponse)) {
            return false;
        }
        DescribeCommentsResponse other = (DescribeCommentsResponse) obj;
        return hasComments() == other.hasComments() && Objects.equals(comments(), other.comments())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCommentsResponse").add("Comments", hasComments() ? comments() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comments":
            return Optional.ofNullable(clazz.cast(comments()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCommentsResponse, T> g) {
        return obj -> g.apply((DescribeCommentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCommentsResponse> {
        /**
         * <p>
         * The list of comments for the specified document version.
         * </p>
         * 
         * @param comments
         *        The list of comments for the specified document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comments(Collection<Comment> comments);

        /**
         * <p>
         * The list of comments for the specified document version.
         * </p>
         * 
         * @param comments
         *        The list of comments for the specified document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comments(Comment... comments);

        /**
         * <p>
         * The list of comments for the specified document version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Comment>.Builder} avoiding the need to
         * create one manually via {@link List<Comment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Comment>.Builder#build()} is called immediately and its
         * result is passed to {@link #comments(List<Comment>)}.
         * 
         * @param comments
         *        a consumer that will call methods on {@link List<Comment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comments(List<Comment>)
         */
        Builder comments(Consumer<Comment.Builder>... comments);

        /**
         * <p>
         * The marker for the next set of results. This marker was received from a previous call.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results. This marker was received from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private List<Comment> comments = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommentsResponse model) {
            super(model);
            comments(model.comments);
            marker(model.marker);
        }

        public final Collection<Comment.Builder> getComments() {
            if (comments instanceof SdkAutoConstructList) {
                return null;
            }
            return comments != null ? comments.stream().map(Comment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder comments(Collection<Comment> comments) {
            this.comments = CommentListCopier.copy(comments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Comment... comments) {
            comments(Arrays.asList(comments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Consumer<Comment.Builder>... comments) {
            comments(Stream.of(comments).map(c -> Comment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComments(Collection<Comment.BuilderImpl> comments) {
            this.comments = CommentListCopier.copyFromBuilder(comments);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeCommentsResponse build() {
            return new DescribeCommentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
