/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActivitiesRequest extends WorkDocsRequest implements
        ToCopyableBuilder<DescribeActivitiesRequest.Builder, DescribeActivitiesRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(DescribeActivitiesRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeActivitiesRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeActivitiesRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(DescribeActivitiesRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("organizationId").build())
            .build();

    private static final SdkField<String> ACTIVITY_TYPES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivityTypes").getter(getter(DescribeActivitiesRequest::activityTypes))
            .setter(setter(Builder::activityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("activityTypes").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(DescribeActivitiesRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(DescribeActivitiesRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()).build();

    private static final SdkField<Boolean> INCLUDE_INDIRECT_ACTIVITIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeIndirectActivities")
            .getter(getter(DescribeActivitiesRequest::includeIndirectActivities))
            .setter(setter(Builder::includeIndirectActivities))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeIndirectActivities")
                    .build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeActivitiesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeActivitiesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, ORGANIZATION_ID_FIELD, ACTIVITY_TYPES_FIELD, RESOURCE_ID_FIELD, USER_ID_FIELD,
            INCLUDE_INDIRECT_ACTIVITIES_FIELD, LIMIT_FIELD, MARKER_FIELD));

    private final String authenticationToken;

    private final Instant startTime;

    private final Instant endTime;

    private final String organizationId;

    private final String activityTypes;

    private final String resourceId;

    private final String userId;

    private final Boolean includeIndirectActivities;

    private final Integer limit;

    private final String marker;

    private DescribeActivitiesRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.organizationId = builder.organizationId;
        this.activityTypes = builder.activityTypes;
        this.resourceId = builder.resourceId;
        this.userId = builder.userId;
        this.includeIndirectActivities = builder.includeIndirectActivities;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The timestamp that determines the starting time of the activities. The response includes the activities performed
     * after the specified timestamp.
     * </p>
     * 
     * @return The timestamp that determines the starting time of the activities. The response includes the activities
     *         performed after the specified timestamp.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp that determines the end time of the activities. The response includes the activities performed
     * before the specified timestamp.
     * </p>
     * 
     * @return The timestamp that determines the end time of the activities. The response includes the activities
     *         performed before the specified timestamp.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.
     * </p>
     * 
     * @return The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * Specifies which activity types to include in the response. If this field is left empty, all activity types are
     * returned.
     * </p>
     * 
     * @return Specifies which activity types to include in the response. If this field is left empty, all activity
     *         types are returned.
     */
    public final String activityTypes() {
        return activityTypes;
    }

    /**
     * <p>
     * The document or folder ID for which to describe activity types.
     * </p>
     * 
     * @return The document or folder ID for which to describe activity types.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The ID of the user who performed the action. The response includes activities pertaining to this user. This is an
     * optional parameter and is only applicable for administrative API (SigV4) requests.
     * </p>
     * 
     * @return The ID of the user who performed the action. The response includes activities pertaining to this user.
     *         This is an optional parameter and is only applicable for administrative API (SigV4) requests.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Includes indirect activities. An indirect activity results from a direct activity performed on a parent resource.
     * For example, sharing a parent folder (the direct activity) shares all of the subfolders and documents within the
     * parent folder (the indirect activity).
     * </p>
     * 
     * @return Includes indirect activities. An indirect activity results from a direct activity performed on a parent
     *         resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and
     *         documents within the parent folder (the indirect activity).
     */
    public final Boolean includeIndirectActivities() {
        return includeIndirectActivities;
    }

    /**
     * <p>
     * The maximum number of items to return.
     * </p>
     * 
     * @return The maximum number of items to return.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(activityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(includeIndirectActivities());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivitiesRequest)) {
            return false;
        }
        DescribeActivitiesRequest other = (DescribeActivitiesRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(activityTypes(), other.activityTypes()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(userId(), other.userId())
                && Objects.equals(includeIndirectActivities(), other.includeIndirectActivities())
                && Objects.equals(limit(), other.limit()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeActivitiesRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StartTime", startTime()).add("EndTime", endTime()).add("OrganizationId", organizationId())
                .add("ActivityTypes", activityTypes()).add("ResourceId", resourceId()).add("UserId", userId())
                .add("IncludeIndirectActivities", includeIndirectActivities()).add("Limit", limit()).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "ActivityTypes":
            return Optional.ofNullable(clazz.cast(activityTypes()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "IncludeIndirectActivities":
            return Optional.ofNullable(clazz.cast(includeIndirectActivities()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivitiesRequest, T> g) {
        return obj -> g.apply((DescribeActivitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeActivitiesRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The timestamp that determines the starting time of the activities. The response includes the activities
         * performed after the specified timestamp.
         * </p>
         * 
         * @param startTime
         *        The timestamp that determines the starting time of the activities. The response includes the
         *        activities performed after the specified timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp that determines the end time of the activities. The response includes the activities performed
         * before the specified timestamp.
         * </p>
         * 
         * @param endTime
         *        The timestamp that determines the end time of the activities. The response includes the activities
         *        performed before the specified timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The ID of the organization. This is a mandatory parameter when using administrative API (SigV4) requests.
         * </p>
         * 
         * @param organizationId
         *        The ID of the organization. This is a mandatory parameter when using administrative API (SigV4)
         *        requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * Specifies which activity types to include in the response. If this field is left empty, all activity types
         * are returned.
         * </p>
         * 
         * @param activityTypes
         *        Specifies which activity types to include in the response. If this field is left empty, all activity
         *        types are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTypes(String activityTypes);

        /**
         * <p>
         * The document or folder ID for which to describe activity types.
         * </p>
         * 
         * @param resourceId
         *        The document or folder ID for which to describe activity types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The ID of the user who performed the action. The response includes activities pertaining to this user. This
         * is an optional parameter and is only applicable for administrative API (SigV4) requests.
         * </p>
         * 
         * @param userId
         *        The ID of the user who performed the action. The response includes activities pertaining to this user.
         *        This is an optional parameter and is only applicable for administrative API (SigV4) requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Includes indirect activities. An indirect activity results from a direct activity performed on a parent
         * resource. For example, sharing a parent folder (the direct activity) shares all of the subfolders and
         * documents within the parent folder (the indirect activity).
         * </p>
         * 
         * @param includeIndirectActivities
         *        Includes indirect activities. An indirect activity results from a direct activity performed on a
         *        parent resource. For example, sharing a parent folder (the direct activity) shares all of the
         *        subfolders and documents within the parent folder (the indirect activity).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeIndirectActivities(Boolean includeIndirectActivities);

        /**
         * <p>
         * The maximum number of items to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private Instant startTime;

        private Instant endTime;

        private String organizationId;

        private String activityTypes;

        private String resourceId;

        private String userId;

        private Boolean includeIndirectActivities;

        private Integer limit;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivitiesRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            startTime(model.startTime);
            endTime(model.endTime);
            organizationId(model.organizationId);
            activityTypes(model.activityTypes);
            resourceId(model.resourceId);
            userId(model.userId);
            includeIndirectActivities(model.includeIndirectActivities);
            limit(model.limit);
            marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getActivityTypes() {
            return activityTypes;
        }

        @Override
        public final Builder activityTypes(String activityTypes) {
            this.activityTypes = activityTypes;
            return this;
        }

        public final void setActivityTypes(String activityTypes) {
            this.activityTypes = activityTypes;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Boolean getIncludeIndirectActivities() {
            return includeIndirectActivities;
        }

        @Override
        public final Builder includeIndirectActivities(Boolean includeIndirectActivities) {
            this.includeIndirectActivities = includeIndirectActivities;
            return this;
        }

        public final void setIncludeIndirectActivities(Boolean includeIndirectActivities) {
            this.includeIndirectActivities = includeIndirectActivities;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeActivitiesRequest build() {
            return new DescribeActivitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
