/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCustomMetadataRequest extends WorkDocsRequest implements
        ToCopyableBuilder<DeleteCustomMetadataRequest.Builder, DeleteCustomMetadataRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(DeleteCustomMetadataRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(DeleteCustomMetadataRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(DeleteCustomMetadataRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("versionId").build()).build();

    private static final SdkField<List<String>> KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(DeleteCustomMetadataRequest::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETE_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteAll").getter(getter(DeleteCustomMetadataRequest::deleteAll)).setter(setter(Builder::deleteAll))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deleteAll").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            RESOURCE_ID_FIELD, VERSION_ID_FIELD, KEYS_FIELD, DELETE_ALL_FIELD));

    private final String authenticationToken;

    private final String resourceId;

    private final String versionId;

    private final List<String> keys;

    private final Boolean deleteAll;

    private DeleteCustomMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.versionId = builder.versionId;
        this.keys = builder.keys;
        this.deleteAll = builder.deleteAll;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the resource, either a document or folder.
     * </p>
     * 
     * @return The ID of the resource, either a document or folder.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The ID of the version, if the custom metadata is being deleted from a document version.
     * </p>
     * 
     * @return The ID of the version, if the custom metadata is being deleted from a document version.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * Returns true if the Keys property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of properties to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of properties to remove.
     */
    public final List<String> keys() {
        return keys;
    }

    /**
     * <p>
     * Flag to indicate removal of all custom metadata properties from the specified resource.
     * </p>
     * 
     * @return Flag to indicate removal of all custom metadata properties from the specified resource.
     */
    public final Boolean deleteAll() {
        return deleteAll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deleteAll());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomMetadataRequest)) {
            return false;
        }
        DeleteCustomMetadataRequest other = (DeleteCustomMetadataRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(versionId(), other.versionId())
                && hasKeys() == other.hasKeys() && Objects.equals(keys(), other.keys())
                && Objects.equals(deleteAll(), other.deleteAll());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCustomMetadataRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceId", resourceId()).add("VersionId", versionId()).add("Keys", hasKeys() ? keys() : null)
                .add("DeleteAll", deleteAll()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "DeleteAll":
            return Optional.ofNullable(clazz.cast(deleteAll()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCustomMetadataRequest, T> g) {
        return obj -> g.apply((DeleteCustomMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCustomMetadataRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the resource, either a document or folder.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource, either a document or folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The ID of the version, if the custom metadata is being deleted from a document version.
         * </p>
         * 
         * @param versionId
         *        The ID of the version, if the custom metadata is being deleted from a document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * List of properties to remove.
         * </p>
         * 
         * @param keys
         *        List of properties to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<String> keys);

        /**
         * <p>
         * List of properties to remove.
         * </p>
         * 
         * @param keys
         *        List of properties to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(String... keys);

        /**
         * <p>
         * Flag to indicate removal of all custom metadata properties from the specified resource.
         * </p>
         * 
         * @param deleteAll
         *        Flag to indicate removal of all custom metadata properties from the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAll(Boolean deleteAll);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String resourceId;

        private String versionId;

        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private Boolean deleteAll;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomMetadataRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            resourceId(model.resourceId);
            versionId(model.versionId);
            keys(model.keys);
            deleteAll(model.deleteAll);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Collection<String> getKeys() {
            if (keys instanceof SdkAutoConstructList) {
                return null;
            }
            return keys;
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = CustomMetadataKeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = CustomMetadataKeyListCopier.copy(keys);
        }

        public final Boolean getDeleteAll() {
            return deleteAll;
        }

        @Override
        public final Builder deleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
            return this;
        }

        public final void setDeleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomMetadataRequest build() {
            return new DeleteCustomMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
