/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActivitiesRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DescribeActivitiesRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::authenticationToken)).setter(DescribeActivitiesRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::startTime)).setter(DescribeActivitiesRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::endTime)).setter(DescribeActivitiesRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::organizationId)).setter(DescribeActivitiesRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("organizationId").build()}).build();
    private static final SdkField<String> ACTIVITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityTypes").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::activityTypes)).setter(DescribeActivitiesRequest.setter(Builder::activityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("activityTypes").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::resourceId)).setter(DescribeActivitiesRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::userId)).setter(DescribeActivitiesRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()}).build();
    private static final SdkField<Boolean> INCLUDE_INDIRECT_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeIndirectActivities").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::includeIndirectActivities)).setter(DescribeActivitiesRequest.setter(Builder::includeIndirectActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeIndirectActivities").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::limit)).setter(DescribeActivitiesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeActivitiesRequest.getter(DescribeActivitiesRequest::marker)).setter(DescribeActivitiesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, START_TIME_FIELD, END_TIME_FIELD, ORGANIZATION_ID_FIELD, ACTIVITY_TYPES_FIELD, RESOURCE_ID_FIELD, USER_ID_FIELD, INCLUDE_INDIRECT_ACTIVITIES_FIELD, LIMIT_FIELD, MARKER_FIELD));
    private final String authenticationToken;
    private final Instant startTime;
    private final Instant endTime;
    private final String organizationId;
    private final String activityTypes;
    private final String resourceId;
    private final String userId;
    private final Boolean includeIndirectActivities;
    private final Integer limit;
    private final String marker;

    private DescribeActivitiesRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.organizationId = builder.organizationId;
        this.activityTypes = builder.activityTypes;
        this.resourceId = builder.resourceId;
        this.userId = builder.userId;
        this.includeIndirectActivities = builder.includeIndirectActivities;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String activityTypes() {
        return this.activityTypes;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String userId() {
        return this.userId;
    }

    public final Boolean includeIndirectActivities() {
        return this.includeIndirectActivities;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeIndirectActivities());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivitiesRequest)) {
            return false;
        }
        DescribeActivitiesRequest other = (DescribeActivitiesRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.activityTypes(), other.activityTypes()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.includeIndirectActivities(), other.includeIndirectActivities()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeActivitiesRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("OrganizationId", (Object)this.organizationId()).add("ActivityTypes", (Object)this.activityTypes()).add("ResourceId", (Object)this.resourceId()).add("UserId", (Object)this.userId()).add("IncludeIndirectActivities", (Object)this.includeIndirectActivities()).add("Limit", (Object)this.limit()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "ActivityTypes": {
                return Optional.ofNullable(clazz.cast(this.activityTypes()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "IncludeIndirectActivities": {
                return Optional.ofNullable(clazz.cast(this.includeIndirectActivities()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivitiesRequest, T> g) {
        return obj -> g.apply((DescribeActivitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private Instant startTime;
        private Instant endTime;
        private String organizationId;
        private String activityTypes;
        private String resourceId;
        private String userId;
        private Boolean includeIndirectActivities;
        private Integer limit;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivitiesRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.organizationId(model.organizationId);
            this.activityTypes(model.activityTypes);
            this.resourceId(model.resourceId);
            this.userId(model.userId);
            this.includeIndirectActivities(model.includeIndirectActivities);
            this.limit(model.limit);
            this.marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getActivityTypes() {
            return this.activityTypes;
        }

        @Override
        public final Builder activityTypes(String activityTypes) {
            this.activityTypes = activityTypes;
            return this;
        }

        public final void setActivityTypes(String activityTypes) {
            this.activityTypes = activityTypes;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Boolean getIncludeIndirectActivities() {
            return this.includeIndirectActivities;
        }

        @Override
        public final Builder includeIndirectActivities(Boolean includeIndirectActivities) {
            this.includeIndirectActivities = includeIndirectActivities;
            return this;
        }

        public final void setIncludeIndirectActivities(Boolean includeIndirectActivities) {
            this.includeIndirectActivities = includeIndirectActivities;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeActivitiesRequest build() {
            return new DescribeActivitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActivitiesRequest> {
        public Builder authenticationToken(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder organizationId(String var1);

        public Builder activityTypes(String var1);

        public Builder resourceId(String var1);

        public Builder userId(String var1);

        public Builder includeIndirectActivities(Boolean var1);

        public Builder limit(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

