/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFolderRequest extends WorkDocsRequest implements
        ToCopyableBuilder<UpdateFolderRequest.Builder, UpdateFolderRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFolderRequest::authenticationToken)).setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFolderRequest::folderId)).setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FolderId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFolderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PARENT_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFolderRequest::parentFolderId)).setter(setter(Builder::parentFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderId").build()).build();

    private static final SdkField<String> RESOURCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFolderRequest::resourceStateAsString)).setter(setter(Builder::resourceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            FOLDER_ID_FIELD, NAME_FIELD, PARENT_FOLDER_ID_FIELD, RESOURCE_STATE_FIELD));

    private final String authenticationToken;

    private final String folderId;

    private final String name;

    private final String parentFolderId;

    private final String resourceState;

    private UpdateFolderRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.name = builder.name;
        this.parentFolderId = builder.parentFolderId;
        this.resourceState = builder.resourceState;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the folder.
     * </p>
     * 
     * @return The ID of the folder.
     */
    public String folderId() {
        return folderId;
    }

    /**
     * <p>
     * The name of the folder.
     * </p>
     * 
     * @return The name of the folder.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the parent folder.
     * </p>
     * 
     * @return The ID of the parent folder.
     */
    public String parentFolderId() {
        return parentFolderId;
    }

    /**
     * <p>
     * The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceState}
     * will return {@link ResourceStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStateAsString}.
     * </p>
     * 
     * @return The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.
     * @see ResourceStateType
     */
    public ResourceStateType resourceState() {
        return ResourceStateType.fromValue(resourceState);
    }

    /**
     * <p>
     * The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceState}
     * will return {@link ResourceStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStateAsString}.
     * </p>
     * 
     * @return The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.
     * @see ResourceStateType
     */
    public String resourceStateAsString() {
        return resourceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFolderRequest)) {
            return false;
        }
        UpdateFolderRequest other = (UpdateFolderRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken()) && Objects.equals(folderId(), other.folderId())
                && Objects.equals(name(), other.name()) && Objects.equals(parentFolderId(), other.parentFolderId())
                && Objects.equals(resourceStateAsString(), other.resourceStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFolderRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FolderId", folderId()).add("Name", name()).add("ParentFolderId", parentFolderId())
                .add("ResourceState", resourceStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ParentFolderId":
            return Optional.ofNullable(clazz.cast(parentFolderId()));
        case "ResourceState":
            return Optional.ofNullable(clazz.cast(resourceStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFolderRequest, T> g) {
        return obj -> g.apply((UpdateFolderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFolderRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the folder.
         * </p>
         * 
         * @param folderId
         *        The ID of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * The name of the folder.
         * </p>
         * 
         * @param name
         *        The name of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the parent folder.
         * </p>
         * 
         * @param parentFolderId
         *        The ID of the parent folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFolderId(String parentFolderId);

        /**
         * <p>
         * The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.
         * </p>
         * 
         * @param resourceState
         *        The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.
         * @see ResourceStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStateType
         */
        Builder resourceState(String resourceState);

        /**
         * <p>
         * The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.
         * </p>
         * 
         * @param resourceState
         *        The resource state of the folder. Only ACTIVE and RECYCLED are accepted values from the API.
         * @see ResourceStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStateType
         */
        Builder resourceState(ResourceStateType resourceState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String folderId;

        private String name;

        private String parentFolderId;

        private String resourceState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFolderRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            folderId(model.folderId);
            name(model.name);
            parentFolderId(model.parentFolderId);
            resourceState(model.resourceState);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getFolderId() {
            return folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getParentFolderId() {
            return parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public final String getResourceState() {
            return resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState == null ? null : resourceState.toString());
            return this;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFolderRequest build() {
            return new UpdateFolderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
