/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentVersionRequest extends WorkDocsRequest implements
        ToCopyableBuilder<GetDocumentVersionRequest.Builder, GetDocumentVersionRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDocumentVersionRequest::authenticationToken)).setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDocumentVersionRequest::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DocumentId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDocumentVersionRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionId").build()).build();

    private static final SdkField<String> FIELDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDocumentVersionRequest::fields)).setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fields").build()).build();

    private static final SdkField<Boolean> INCLUDE_CUSTOM_METADATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetDocumentVersionRequest::includeCustomMetadata)).setter(setter(Builder::includeCustomMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeCustomMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            DOCUMENT_ID_FIELD, VERSION_ID_FIELD, FIELDS_FIELD, INCLUDE_CUSTOM_METADATA_FIELD));

    private final String authenticationToken;

    private final String documentId;

    private final String versionId;

    private final String fields;

    private final Boolean includeCustomMetadata;

    private GetDocumentVersionRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.versionId = builder.versionId;
        this.fields = builder.fields;
        this.includeCustomMetadata = builder.includeCustomMetadata;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the document.
     * </p>
     * 
     * @return The ID of the document.
     */
    public String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The version ID of the document.
     * </p>
     * 
     * @return The version ID of the document.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.
     * </p>
     * 
     * @return A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.
     */
    public String fields() {
        return fields;
    }

    /**
     * <p>
     * Set this to TRUE to include custom metadata in the response.
     * </p>
     * 
     * @return Set this to TRUE to include custom metadata in the response.
     */
    public Boolean includeCustomMetadata() {
        return includeCustomMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(fields());
        hashCode = 31 * hashCode + Objects.hashCode(includeCustomMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentVersionRequest)) {
            return false;
        }
        GetDocumentVersionRequest other = (GetDocumentVersionRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(documentId(), other.documentId()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(fields(), other.fields())
                && Objects.equals(includeCustomMetadata(), other.includeCustomMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDocumentVersionRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentId", documentId()).add("VersionId", versionId()).add("Fields", fields())
                .add("IncludeCustomMetadata", includeCustomMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "IncludeCustomMetadata":
            return Optional.ofNullable(clazz.cast(includeCustomMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentVersionRequest, T> g) {
        return obj -> g.apply((GetDocumentVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDocumentVersionRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the document.
         * </p>
         * 
         * @param documentId
         *        The ID of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The version ID of the document.
         * </p>
         * 
         * @param versionId
         *        The version ID of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.
         * </p>
         * 
         * @param fields
         *        A comma-separated list of values. Specify "SOURCE" to include a URL for the source document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(String fields);

        /**
         * <p>
         * Set this to TRUE to include custom metadata in the response.
         * </p>
         * 
         * @param includeCustomMetadata
         *        Set this to TRUE to include custom metadata in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCustomMetadata(Boolean includeCustomMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String documentId;

        private String versionId;

        private String fields;

        private Boolean includeCustomMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentVersionRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            documentId(model.documentId);
            versionId(model.versionId);
            fields(model.fields);
            includeCustomMetadata(model.includeCustomMetadata);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getFields() {
            return fields;
        }

        @Override
        public final Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public final void setFields(String fields) {
            this.fields = fields;
        }

        public final Boolean getIncludeCustomMetadata() {
            return includeCustomMetadata;
        }

        @Override
        public final Builder includeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
            return this;
        }

        public final void setIncludeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentVersionRequest build() {
            return new GetDocumentVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
