/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddResourcePermissionsRequest extends WorkDocsRequest implements
        ToCopyableBuilder<AddResourcePermissionsRequest.Builder, AddResourcePermissionsRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddResourcePermissionsRequest::authenticationToken)).setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddResourcePermissionsRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceId").build()).build();

    private static final SdkField<List<SharePrincipal>> PRINCIPALS_FIELD = SdkField
            .<List<SharePrincipal>> builder(MarshallingType.LIST)
            .getter(getter(AddResourcePermissionsRequest::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SharePrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(SharePrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NotificationOptions> NOTIFICATION_OPTIONS_FIELD = SdkField
            .<NotificationOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(AddResourcePermissionsRequest::notificationOptions)).setter(setter(Builder::notificationOptions))
            .constructor(NotificationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            RESOURCE_ID_FIELD, PRINCIPALS_FIELD, NOTIFICATION_OPTIONS_FIELD));

    private final String authenticationToken;

    private final String resourceId;

    private final List<SharePrincipal> principals;

    private final NotificationOptions notificationOptions;

    private AddResourcePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.principals = builder.principals;
        this.notificationOptions = builder.notificationOptions;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * Returns true if the Principals property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The users, groups, or organization being granted permission.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrincipals()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The users, groups, or organization being granted permission.
     */
    public List<SharePrincipal> principals() {
        return principals;
    }

    /**
     * <p>
     * The notification options.
     * </p>
     * 
     * @return The notification options.
     */
    public NotificationOptions notificationOptions() {
        return notificationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(principals());
        hashCode = 31 * hashCode + Objects.hashCode(notificationOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddResourcePermissionsRequest)) {
            return false;
        }
        AddResourcePermissionsRequest other = (AddResourcePermissionsRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(principals(), other.principals())
                && Objects.equals(notificationOptions(), other.notificationOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddResourcePermissionsRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceId", resourceId()).add("Principals", principals())
                .add("NotificationOptions", notificationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "NotificationOptions":
            return Optional.ofNullable(clazz.cast(notificationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddResourcePermissionsRequest, T> g) {
        return obj -> g.apply((AddResourcePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddResourcePermissionsRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The users, groups, or organization being granted permission.
         * </p>
         * 
         * @param principals
         *        The users, groups, or organization being granted permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<SharePrincipal> principals);

        /**
         * <p>
         * The users, groups, or organization being granted permission.
         * </p>
         * 
         * @param principals
         *        The users, groups, or organization being granted permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(SharePrincipal... principals);

        /**
         * <p>
         * The users, groups, or organization being granted permission.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SharePrincipal>.Builder} avoiding the need
         * to create one manually via {@link List<SharePrincipal>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SharePrincipal>.Builder#build()} is called immediately and
         * its result is passed to {@link #principals(List<SharePrincipal>)}.
         * 
         * @param principals
         *        a consumer that will call methods on {@link List<SharePrincipal>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principals(List<SharePrincipal>)
         */
        Builder principals(Consumer<SharePrincipal.Builder>... principals);

        /**
         * <p>
         * The notification options.
         * </p>
         * 
         * @param notificationOptions
         *        The notification options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationOptions(NotificationOptions notificationOptions);

        /**
         * <p>
         * The notification options.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationOptions.Builder} avoiding the need
         * to create one manually via {@link NotificationOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #notificationOptions(NotificationOptions)}.
         * 
         * @param notificationOptions
         *        a consumer that will call methods on {@link NotificationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationOptions(NotificationOptions)
         */
        default Builder notificationOptions(Consumer<NotificationOptions.Builder> notificationOptions) {
            return notificationOptions(NotificationOptions.builder().applyMutation(notificationOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String resourceId;

        private List<SharePrincipal> principals = DefaultSdkAutoConstructList.getInstance();

        private NotificationOptions notificationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AddResourcePermissionsRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            resourceId(model.resourceId);
            principals(model.principals);
            notificationOptions(model.notificationOptions);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<SharePrincipal.Builder> getPrincipals() {
            return principals != null ? principals.stream().map(SharePrincipal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder principals(Collection<SharePrincipal> principals) {
            this.principals = SharePrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(SharePrincipal... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<SharePrincipal.Builder>... principals) {
            principals(Stream.of(principals).map(c -> SharePrincipal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipals(Collection<SharePrincipal.BuilderImpl> principals) {
            this.principals = SharePrincipalListCopier.copyFromBuilder(principals);
        }

        public final NotificationOptions.Builder getNotificationOptions() {
            return notificationOptions != null ? notificationOptions.toBuilder() : null;
        }

        @Override
        public final Builder notificationOptions(NotificationOptions notificationOptions) {
            this.notificationOptions = notificationOptions;
            return this;
        }

        public final void setNotificationOptions(NotificationOptions.BuilderImpl notificationOptions) {
            this.notificationOptions = notificationOptions != null ? notificationOptions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddResourcePermissionsRequest build() {
            return new AddResourcePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
