/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ActivityType {
    DOCUMENT_CHECKED_IN("DOCUMENT_CHECKED_IN"),

    DOCUMENT_CHECKED_OUT("DOCUMENT_CHECKED_OUT"),

    DOCUMENT_RENAMED("DOCUMENT_RENAMED"),

    DOCUMENT_VERSION_UPLOADED("DOCUMENT_VERSION_UPLOADED"),

    DOCUMENT_VERSION_DELETED("DOCUMENT_VERSION_DELETED"),

    DOCUMENT_VERSION_VIEWED("DOCUMENT_VERSION_VIEWED"),

    DOCUMENT_VERSION_DOWNLOADED("DOCUMENT_VERSION_DOWNLOADED"),

    DOCUMENT_RECYCLED("DOCUMENT_RECYCLED"),

    DOCUMENT_RESTORED("DOCUMENT_RESTORED"),

    DOCUMENT_REVERTED("DOCUMENT_REVERTED"),

    DOCUMENT_SHARED("DOCUMENT_SHARED"),

    DOCUMENT_UNSHARED("DOCUMENT_UNSHARED"),

    DOCUMENT_SHARE_PERMISSION_CHANGED("DOCUMENT_SHARE_PERMISSION_CHANGED"),

    DOCUMENT_SHAREABLE_LINK_CREATED("DOCUMENT_SHAREABLE_LINK_CREATED"),

    DOCUMENT_SHAREABLE_LINK_REMOVED("DOCUMENT_SHAREABLE_LINK_REMOVED"),

    DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED("DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED"),

    DOCUMENT_MOVED("DOCUMENT_MOVED"),

    DOCUMENT_COMMENT_ADDED("DOCUMENT_COMMENT_ADDED"),

    DOCUMENT_COMMENT_DELETED("DOCUMENT_COMMENT_DELETED"),

    DOCUMENT_ANNOTATION_ADDED("DOCUMENT_ANNOTATION_ADDED"),

    DOCUMENT_ANNOTATION_DELETED("DOCUMENT_ANNOTATION_DELETED"),

    FOLDER_CREATED("FOLDER_CREATED"),

    FOLDER_DELETED("FOLDER_DELETED"),

    FOLDER_RENAMED("FOLDER_RENAMED"),

    FOLDER_RECYCLED("FOLDER_RECYCLED"),

    FOLDER_RESTORED("FOLDER_RESTORED"),

    FOLDER_SHARED("FOLDER_SHARED"),

    FOLDER_UNSHARED("FOLDER_UNSHARED"),

    FOLDER_SHARE_PERMISSION_CHANGED("FOLDER_SHARE_PERMISSION_CHANGED"),

    FOLDER_SHAREABLE_LINK_CREATED("FOLDER_SHAREABLE_LINK_CREATED"),

    FOLDER_SHAREABLE_LINK_REMOVED("FOLDER_SHAREABLE_LINK_REMOVED"),

    FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED("FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED"),

    FOLDER_MOVED("FOLDER_MOVED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ActivityType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ActivityType corresponding to the value
     */
    public static ActivityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ActivityType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ActivityType}s
     */
    public static Set<ActivityType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
