/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the storage for a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserStorageMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<UserStorageMetadata.Builder, UserStorageMetadata> {
    private static final SdkField<Long> STORAGE_UTILIZED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UserStorageMetadata::storageUtilizedInBytes)).setter(setter(Builder::storageUtilizedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageUtilizedInBytes").build())
            .build();

    private static final SdkField<StorageRuleType> STORAGE_RULE_FIELD = SdkField
            .<StorageRuleType> builder(MarshallingType.SDK_POJO).getter(getter(UserStorageMetadata::storageRule))
            .setter(setter(Builder::storageRule)).constructor(StorageRuleType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORAGE_UTILIZED_IN_BYTES_FIELD, STORAGE_RULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long storageUtilizedInBytes;

    private final StorageRuleType storageRule;

    private UserStorageMetadata(BuilderImpl builder) {
        this.storageUtilizedInBytes = builder.storageUtilizedInBytes;
        this.storageRule = builder.storageRule;
    }

    /**
     * <p>
     * The amount of storage used, in bytes.
     * </p>
     * 
     * @return The amount of storage used, in bytes.
     */
    public Long storageUtilizedInBytes() {
        return storageUtilizedInBytes;
    }

    /**
     * <p>
     * The storage for a user.
     * </p>
     * 
     * @return The storage for a user.
     */
    public StorageRuleType storageRule() {
        return storageRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageUtilizedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(storageRule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserStorageMetadata)) {
            return false;
        }
        UserStorageMetadata other = (UserStorageMetadata) obj;
        return Objects.equals(storageUtilizedInBytes(), other.storageUtilizedInBytes())
                && Objects.equals(storageRule(), other.storageRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserStorageMetadata").add("StorageUtilizedInBytes", storageUtilizedInBytes())
                .add("StorageRule", storageRule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageUtilizedInBytes":
            return Optional.ofNullable(clazz.cast(storageUtilizedInBytes()));
        case "StorageRule":
            return Optional.ofNullable(clazz.cast(storageRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserStorageMetadata, T> g) {
        return obj -> g.apply((UserStorageMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserStorageMetadata> {
        /**
         * <p>
         * The amount of storage used, in bytes.
         * </p>
         * 
         * @param storageUtilizedInBytes
         *        The amount of storage used, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageUtilizedInBytes(Long storageUtilizedInBytes);

        /**
         * <p>
         * The storage for a user.
         * </p>
         * 
         * @param storageRule
         *        The storage for a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageRule(StorageRuleType storageRule);

        /**
         * <p>
         * The storage for a user.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageRuleType.Builder} avoiding the need to
         * create one manually via {@link StorageRuleType#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageRuleType.Builder#build()} is called immediately and its
         * result is passed to {@link #storageRule(StorageRuleType)}.
         * 
         * @param storageRule
         *        a consumer that will call methods on {@link StorageRuleType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageRule(StorageRuleType)
         */
        default Builder storageRule(Consumer<StorageRuleType.Builder> storageRule) {
            return storageRule(StorageRuleType.builder().applyMutation(storageRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long storageUtilizedInBytes;

        private StorageRuleType storageRule;

        private BuilderImpl() {
        }

        private BuilderImpl(UserStorageMetadata model) {
            storageUtilizedInBytes(model.storageUtilizedInBytes);
            storageRule(model.storageRule);
        }

        public final Long getStorageUtilizedInBytes() {
            return storageUtilizedInBytes;
        }

        @Override
        public final Builder storageUtilizedInBytes(Long storageUtilizedInBytes) {
            this.storageUtilizedInBytes = storageUtilizedInBytes;
            return this;
        }

        public final void setStorageUtilizedInBytes(Long storageUtilizedInBytes) {
            this.storageUtilizedInBytes = storageUtilizedInBytes;
        }

        public final StorageRuleType.Builder getStorageRule() {
            return storageRule != null ? storageRule.toBuilder() : null;
        }

        @Override
        public final Builder storageRule(StorageRuleType storageRule) {
            this.storageRule = storageRule;
            return this;
        }

        public final void setStorageRule(StorageRuleType.BuilderImpl storageRule) {
            this.storageRule = storageRule != null ? storageRule.build() : null;
        }

        @Override
        public UserStorageMetadata build() {
            return new UserStorageMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
