/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the path information of a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePath implements SdkPojo, Serializable, ToCopyableBuilder<ResourcePath.Builder, ResourcePath> {
    private static final SdkField<List<ResourcePathComponent>> COMPONENTS_FIELD = SdkField
            .<List<ResourcePathComponent>> builder(MarshallingType.LIST)
            .getter(getter(ResourcePath::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePathComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePathComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ResourcePathComponent> components;

    private ResourcePath(BuilderImpl builder) {
        this.components = builder.components;
    }

    /**
     * Returns true if the Components property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The components of the resource path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComponents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The components of the resource path.
     */
    public List<ResourcePathComponent> components() {
        return components;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(components());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath other = (ResourcePath) obj;
        return Objects.equals(components(), other.components());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourcePath").add("Components", components()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Components":
            return Optional.ofNullable(clazz.cast(components()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePath, T> g) {
        return obj -> g.apply((ResourcePath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePath> {
        /**
         * <p>
         * The components of the resource path.
         * </p>
         * 
         * @param components
         *        The components of the resource path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<ResourcePathComponent> components);

        /**
         * <p>
         * The components of the resource path.
         * </p>
         * 
         * @param components
         *        The components of the resource path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ResourcePathComponent... components);

        /**
         * <p>
         * The components of the resource path.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePathComponent>.Builder} avoiding
         * the need to create one manually via {@link List<ResourcePathComponent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePathComponent>.Builder#build()} is called
         * immediately and its result is passed to {@link #components(List<ResourcePathComponent>)}.
         * 
         * @param components
         *        a consumer that will call methods on {@link List<ResourcePathComponent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(List<ResourcePathComponent>)
         */
        Builder components(Consumer<ResourcePathComponent.Builder>... components);
    }

    static final class BuilderImpl implements Builder {
        private List<ResourcePathComponent> components = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePath model) {
            components(model.components);
        }

        public final Collection<ResourcePathComponent.Builder> getComponents() {
            return components != null ? components.stream().map(ResourcePathComponent::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder components(Collection<ResourcePathComponent> components) {
            this.components = ResourcePathComponentListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ResourcePathComponent... components) {
            components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<ResourcePathComponent.Builder>... components) {
            components(Stream.of(components).map(c -> ResourcePathComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setComponents(Collection<ResourcePathComponent.BuilderImpl> components) {
            this.components = ResourcePathComponentListCopier.copyFromBuilder(components);
        }

        @Override
        public ResourcePath build() {
            return new ResourcePath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
