/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Set of options which defines notification preferences of given action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationOptions.Builder, NotificationOptions> {
    private static final SdkField<Boolean> SEND_EMAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(NotificationOptions::sendEmail)).setter(setter(Builder::sendEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendEmail").build()).build();

    private static final SdkField<String> EMAIL_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NotificationOptions::emailMessage)).setter(setter(Builder::emailMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEND_EMAIL_FIELD,
            EMAIL_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean sendEmail;

    private final String emailMessage;

    private NotificationOptions(BuilderImpl builder) {
        this.sendEmail = builder.sendEmail;
        this.emailMessage = builder.emailMessage;
    }

    /**
     * <p>
     * Boolean value to indicate an email notification should be sent to the receipients.
     * </p>
     * 
     * @return Boolean value to indicate an email notification should be sent to the receipients.
     */
    public Boolean sendEmail() {
        return sendEmail;
    }

    /**
     * <p>
     * Text value to be included in the email body.
     * </p>
     * 
     * @return Text value to be included in the email body.
     */
    public String emailMessage() {
        return emailMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sendEmail());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationOptions)) {
            return false;
        }
        NotificationOptions other = (NotificationOptions) obj;
        return Objects.equals(sendEmail(), other.sendEmail()) && Objects.equals(emailMessage(), other.emailMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NotificationOptions").add("SendEmail", sendEmail())
                .add("EmailMessage", emailMessage() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SendEmail":
            return Optional.ofNullable(clazz.cast(sendEmail()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationOptions, T> g) {
        return obj -> g.apply((NotificationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationOptions> {
        /**
         * <p>
         * Boolean value to indicate an email notification should be sent to the receipients.
         * </p>
         * 
         * @param sendEmail
         *        Boolean value to indicate an email notification should be sent to the receipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendEmail(Boolean sendEmail);

        /**
         * <p>
         * Text value to be included in the email body.
         * </p>
         * 
         * @param emailMessage
         *        Text value to be included in the email body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(String emailMessage);
    }

    static final class BuilderImpl implements Builder {
        private Boolean sendEmail;

        private String emailMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationOptions model) {
            sendEmail(model.sendEmail);
            emailMessage(model.emailMessage);
        }

        public final Boolean getSendEmail() {
            return sendEmail;
        }

        @Override
        public final Builder sendEmail(Boolean sendEmail) {
            this.sendEmail = sendEmail;
            return this;
        }

        public final void setSendEmail(Boolean sendEmail) {
            this.sendEmail = sendEmail;
        }

        public final String getEmailMessage() {
            return emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        @Override
        public NotificationOptions build() {
            return new NotificationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
