/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesRequest extends WorkDocsRequest implements
        ToCopyableBuilder<GetResourcesRequest.Builder, GetResourcesRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourcesRequest::authenticationToken)).setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourcesRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()).build();

    private static final SdkField<String> COLLECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourcesRequest::collectionTypeAsString)).setter(setter(Builder::collectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("collectionType").build())
            .build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetResourcesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourcesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            USER_ID_FIELD, COLLECTION_TYPE_FIELD, LIMIT_FIELD, MARKER_FIELD));

    private final String authenticationToken;

    private final String userId;

    private final String collectionType;

    private final Integer limit;

    private final String marker;

    private GetResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.userId = builder.userId;
        this.collectionType = builder.collectionType;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in
     * accessing the API operation using AWS credentials.
     * </p>
     * 
     * @return The Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as
     *         in accessing the API operation using AWS credentials.
     */
    public String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The user ID for the resource collection. This is a required field for accessing the API operation using IAM
     * credentials.
     * </p>
     * 
     * @return The user ID for the resource collection. This is a required field for accessing the API operation using
     *         IAM credentials.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The collection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #collectionType}
     * will return {@link ResourceCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #collectionTypeAsString}.
     * </p>
     * 
     * @return The collection type.
     * @see ResourceCollectionType
     */
    public ResourceCollectionType collectionType() {
        return ResourceCollectionType.fromValue(collectionType);
    }

    /**
     * <p>
     * The collection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #collectionType}
     * will return {@link ResourceCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #collectionTypeAsString}.
     * </p>
     * 
     * @return The collection type.
     * @see ResourceCollectionType
     */
    public String collectionTypeAsString() {
        return collectionType;
    }

    /**
     * <p>
     * The maximum number of resources to return.
     * </p>
     * 
     * @return The maximum number of resources to return.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The marker for the next set of results. This marker was received from a previous call.
     * </p>
     * 
     * @return The marker for the next set of results. This marker was received from a previous call.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(collectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesRequest)) {
            return false;
        }
        GetResourcesRequest other = (GetResourcesRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken()) && Objects.equals(userId(), other.userId())
                && Objects.equals(collectionTypeAsString(), other.collectionTypeAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetResourcesRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserId", userId()).add("CollectionType", collectionTypeAsString()).add("Limit", limit())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "CollectionType":
            return Optional.ofNullable(clazz.cast(collectionTypeAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesRequest, T> g) {
        return obj -> g.apply((GetResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourcesRequest> {
        /**
         * <p>
         * The Amazon WorkDocs authentication token. Do not set this field when using administrative API actions, as in
         * accessing the API operation using AWS credentials.
         * </p>
         * 
         * @param authenticationToken
         *        The Amazon WorkDocs authentication token. Do not set this field when using administrative API actions,
         *        as in accessing the API operation using AWS credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The user ID for the resource collection. This is a required field for accessing the API operation using IAM
         * credentials.
         * </p>
         * 
         * @param userId
         *        The user ID for the resource collection. This is a required field for accessing the API operation
         *        using IAM credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The collection type.
         * </p>
         * 
         * @param collectionType
         *        The collection type.
         * @see ResourceCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCollectionType
         */
        Builder collectionType(String collectionType);

        /**
         * <p>
         * The collection type.
         * </p>
         * 
         * @param collectionType
         *        The collection type.
         * @see ResourceCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCollectionType
         */
        Builder collectionType(ResourceCollectionType collectionType);

        /**
         * <p>
         * The maximum number of resources to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of resources to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The marker for the next set of results. This marker was received from a previous call.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results. This marker was received from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String userId;

        private String collectionType;

        private Integer limit;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            userId(model.userId);
            collectionType(model.collectionType);
            limit(model.limit);
            marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getCollectionTypeAsString() {
            return collectionType;
        }

        @Override
        public final Builder collectionType(String collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        @Override
        public final Builder collectionType(ResourceCollectionType collectionType) {
            this.collectionType(collectionType == null ? null : collectionType.toString());
            return this;
        }

        public final void setCollectionType(String collectionType) {
            this.collectionType = collectionType;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesRequest build() {
            return new GetResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
