/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a version of a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentVersionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentVersionMetadata.Builder, DocumentVersionMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentVersionMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentVersionMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentVersionMetadata::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DocumentVersionMetadata::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentVersionMetadata::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentVersionMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DocumentVersionMetadata::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DocumentVersionMetadata::modifiedTimestamp)).setter(setter(Builder::modifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimestamp").build()).build();

    private static final SdkField<Instant> CONTENT_CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DocumentVersionMetadata::contentCreatedTimestamp)).setter(setter(Builder::contentCreatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentCreatedTimestamp").build())
            .build();

    private static final SdkField<Instant> CONTENT_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DocumentVersionMetadata::contentModifiedTimestamp)).setter(setter(Builder::contentModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentModifiedTimestamp").build())
            .build();

    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentVersionMetadata::creatorId)).setter(setter(Builder::creatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()).build();

    private static final SdkField<Map<String, String>> THUMBNAIL_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DocumentVersionMetadata::thumbnailAsStrings))
            .setter(setter(Builder::thumbnailWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thumbnail").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SOURCE_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DocumentVersionMetadata::sourceAsStrings))
            .setter(setter(Builder::sourceWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CONTENT_TYPE_FIELD, SIZE_FIELD, SIGNATURE_FIELD, STATUS_FIELD, CREATED_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD,
            CONTENT_CREATED_TIMESTAMP_FIELD, CONTENT_MODIFIED_TIMESTAMP_FIELD, CREATOR_ID_FIELD, THUMBNAIL_FIELD, SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String contentType;

    private final Long size;

    private final String signature;

    private final String status;

    private final Instant createdTimestamp;

    private final Instant modifiedTimestamp;

    private final Instant contentCreatedTimestamp;

    private final Instant contentModifiedTimestamp;

    private final String creatorId;

    private final Map<String, String> thumbnail;

    private final Map<String, String> source;

    private DocumentVersionMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.contentType = builder.contentType;
        this.size = builder.size;
        this.signature = builder.signature;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.contentCreatedTimestamp = builder.contentCreatedTimestamp;
        this.contentModifiedTimestamp = builder.contentModifiedTimestamp;
        this.creatorId = builder.creatorId;
        this.thumbnail = builder.thumbnail;
        this.source = builder.source;
    }

    /**
     * <p>
     * The ID of the version.
     * </p>
     * 
     * @return The ID of the version.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the version.
     * </p>
     * 
     * @return The name of the version.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The content type of the document.
     * </p>
     * 
     * @return The content type of the document.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The size of the document, in bytes.
     * </p>
     * 
     * @return The size of the document, in bytes.
     */
    public Long size() {
        return size;
    }

    /**
     * <p>
     * The signature of the document.
     * </p>
     * 
     * @return The signature of the document.
     */
    public String signature() {
        return signature;
    }

    /**
     * <p>
     * The status of the document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the document.
     * @see DocumentStatusType
     */
    public DocumentStatusType status() {
        return DocumentStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the document.
     * @see DocumentStatusType
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the document was first uploaded.
     * </p>
     * 
     * @return The timestamp when the document was first uploaded.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp when the document was last uploaded.
     * </p>
     * 
     * @return The timestamp when the document was last uploaded.
     */
    public Instant modifiedTimestamp() {
        return modifiedTimestamp;
    }

    /**
     * <p>
     * The timestamp when the content of the document was originally created.
     * </p>
     * 
     * @return The timestamp when the content of the document was originally created.
     */
    public Instant contentCreatedTimestamp() {
        return contentCreatedTimestamp;
    }

    /**
     * <p>
     * The timestamp when the content of the document was modified.
     * </p>
     * 
     * @return The timestamp when the content of the document was modified.
     */
    public Instant contentModifiedTimestamp() {
        return contentModifiedTimestamp;
    }

    /**
     * <p>
     * The ID of the creator.
     * </p>
     * 
     * @return The ID of the creator.
     */
    public String creatorId() {
        return creatorId;
    }

    /**
     * <p>
     * The thumbnail of the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThumbnail()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The thumbnail of the document.
     */
    public Map<DocumentThumbnailType, String> thumbnail() {
        return DocumentThumbnailUrlMapCopier.copyStringToEnum(thumbnail);
    }

    /**
     * Returns true if the Thumbnail property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasThumbnail() {
        return thumbnail != null && !(thumbnail instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The thumbnail of the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThumbnail()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The thumbnail of the document.
     */
    public Map<String, String> thumbnailAsStrings() {
        return thumbnail;
    }

    /**
     * <p>
     * The source of the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSource()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source of the document.
     */
    public Map<DocumentSourceType, String> source() {
        return DocumentSourceUrlMapCopier.copyStringToEnum(source);
    }

    /**
     * Returns true if the Source property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSource() {
        return source != null && !(source instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The source of the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSource()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source of the document.
     */
    public Map<String, String> sourceAsStrings() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(contentCreatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(contentModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentVersionMetadata)) {
            return false;
        }
        DocumentVersionMetadata other = (DocumentVersionMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(size(), other.size())
                && Objects.equals(signature(), other.signature()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(modifiedTimestamp(), other.modifiedTimestamp())
                && Objects.equals(contentCreatedTimestamp(), other.contentCreatedTimestamp())
                && Objects.equals(contentModifiedTimestamp(), other.contentModifiedTimestamp())
                && Objects.equals(creatorId(), other.creatorId())
                && Objects.equals(thumbnailAsStrings(), other.thumbnailAsStrings())
                && Objects.equals(sourceAsStrings(), other.sourceAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DocumentVersionMetadata").add("Id", id()).add("Name", name()).add("ContentType", contentType())
                .add("Size", size()).add("Signature", signature()).add("Status", statusAsString())
                .add("CreatedTimestamp", createdTimestamp()).add("ModifiedTimestamp", modifiedTimestamp())
                .add("ContentCreatedTimestamp", contentCreatedTimestamp())
                .add("ContentModifiedTimestamp", contentModifiedTimestamp()).add("CreatorId", creatorId())
                .add("Thumbnail", thumbnailAsStrings() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Source", sourceAsStrings() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "Signature":
            return Optional.ofNullable(clazz.cast(signature()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "ModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(modifiedTimestamp()));
        case "ContentCreatedTimestamp":
            return Optional.ofNullable(clazz.cast(contentCreatedTimestamp()));
        case "ContentModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(contentModifiedTimestamp()));
        case "CreatorId":
            return Optional.ofNullable(clazz.cast(creatorId()));
        case "Thumbnail":
            return Optional.ofNullable(clazz.cast(thumbnailAsStrings()));
        case "Source":
            return Optional.ofNullable(clazz.cast(sourceAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentVersionMetadata, T> g) {
        return obj -> g.apply((DocumentVersionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentVersionMetadata> {
        /**
         * <p>
         * The ID of the version.
         * </p>
         * 
         * @param id
         *        The ID of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the version.
         * </p>
         * 
         * @param name
         *        The name of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The content type of the document.
         * </p>
         * 
         * @param contentType
         *        The content type of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The size of the document, in bytes.
         * </p>
         * 
         * @param size
         *        The size of the document, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * <p>
         * The signature of the document.
         * </p>
         * 
         * @param signature
         *        The signature of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        /**
         * <p>
         * The status of the document.
         * </p>
         * 
         * @param status
         *        The status of the document.
         * @see DocumentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the document.
         * </p>
         * 
         * @param status
         *        The status of the document.
         * @see DocumentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatusType
         */
        Builder status(DocumentStatusType status);

        /**
         * <p>
         * The timestamp when the document was first uploaded.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp when the document was first uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp when the document was last uploaded.
         * </p>
         * 
         * @param modifiedTimestamp
         *        The timestamp when the document was last uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTimestamp(Instant modifiedTimestamp);

        /**
         * <p>
         * The timestamp when the content of the document was originally created.
         * </p>
         * 
         * @param contentCreatedTimestamp
         *        The timestamp when the content of the document was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentCreatedTimestamp(Instant contentCreatedTimestamp);

        /**
         * <p>
         * The timestamp when the content of the document was modified.
         * </p>
         * 
         * @param contentModifiedTimestamp
         *        The timestamp when the content of the document was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentModifiedTimestamp(Instant contentModifiedTimestamp);

        /**
         * <p>
         * The ID of the creator.
         * </p>
         * 
         * @param creatorId
         *        The ID of the creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorId(String creatorId);

        /**
         * <p>
         * The thumbnail of the document.
         * </p>
         * 
         * @param thumbnail
         *        The thumbnail of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailWithStrings(Map<String, String> thumbnail);

        /**
         * <p>
         * The thumbnail of the document.
         * </p>
         * 
         * @param thumbnail
         *        The thumbnail of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnail(Map<DocumentThumbnailType, String> thumbnail);

        /**
         * <p>
         * The source of the document.
         * </p>
         * 
         * @param source
         *        The source of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceWithStrings(Map<String, String> source);

        /**
         * <p>
         * The source of the document.
         * </p>
         * 
         * @param source
         *        The source of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Map<DocumentSourceType, String> source);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String contentType;

        private Long size;

        private String signature;

        private String status;

        private Instant createdTimestamp;

        private Instant modifiedTimestamp;

        private Instant contentCreatedTimestamp;

        private Instant contentModifiedTimestamp;

        private String creatorId;

        private Map<String, String> thumbnail = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> source = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentVersionMetadata model) {
            id(model.id);
            name(model.name);
            contentType(model.contentType);
            size(model.size);
            signature(model.signature);
            status(model.status);
            createdTimestamp(model.createdTimestamp);
            modifiedTimestamp(model.modifiedTimestamp);
            contentCreatedTimestamp(model.contentCreatedTimestamp);
            contentModifiedTimestamp(model.contentModifiedTimestamp);
            creatorId(model.creatorId);
            thumbnailWithStrings(model.thumbnail);
            sourceWithStrings(model.source);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getModifiedTimestamp() {
            return modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        public final Instant getContentCreatedTimestamp() {
            return contentCreatedTimestamp;
        }

        @Override
        public final Builder contentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
            return this;
        }

        public final void setContentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
        }

        public final Instant getContentModifiedTimestamp() {
            return contentModifiedTimestamp;
        }

        @Override
        public final Builder contentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
            return this;
        }

        public final void setContentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
        }

        public final String getCreatorId() {
            return creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final Map<String, String> getThumbnailAsStrings() {
            return thumbnail;
        }

        @Override
        public final Builder thumbnailWithStrings(Map<String, String> thumbnail) {
            this.thumbnail = DocumentThumbnailUrlMapCopier.copy(thumbnail);
            return this;
        }

        @Override
        public final Builder thumbnail(Map<DocumentThumbnailType, String> thumbnail) {
            this.thumbnail = DocumentThumbnailUrlMapCopier.copyEnumToString(thumbnail);
            return this;
        }

        public final void setThumbnailWithStrings(Map<String, String> thumbnail) {
            this.thumbnail = DocumentThumbnailUrlMapCopier.copy(thumbnail);
        }

        public final Map<String, String> getSourceAsStrings() {
            return source;
        }

        @Override
        public final Builder sourceWithStrings(Map<String, String> source) {
            this.source = DocumentSourceUrlMapCopier.copy(source);
            return this;
        }

        @Override
        public final Builder source(Map<DocumentSourceType, String> source) {
            this.source = DocumentSourceUrlMapCopier.copyEnumToString(source);
            return this;
        }

        public final void setSourceWithStrings(Map<String, String> source) {
            this.source = DocumentSourceUrlMapCopier.copy(source);
        }

        @Override
        public DocumentVersionMetadata build() {
            return new DocumentVersionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
