/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGroupsResponse extends WorkDocsResponse implements
        ToCopyableBuilder<DescribeGroupsResponse.Builder, DescribeGroupsResponse> {
    private static final SdkField<List<GroupMetadata>> GROUPS_FIELD = SdkField
            .<List<GroupMetadata>> builder(MarshallingType.LIST)
            .getter(getter(DescribeGroupsResponse::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, MARKER_FIELD));

    private final List<GroupMetadata> groups;

    private final String marker;

    private DescribeGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.groups = builder.groups;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of groups.
     */
    public List<GroupMetadata> groups() {
        return groups;
    }

    /**
     * <p>
     * The marker to use when requesting the next set of results. If there are no additional results, the string is
     * empty.
     * </p>
     * 
     * @return The marker to use when requesting the next set of results. If there are no additional results, the string
     *         is empty.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupsResponse)) {
            return false;
        }
        DescribeGroupsResponse other = (DescribeGroupsResponse) obj;
        return Objects.equals(groups(), other.groups()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeGroupsResponse").add("Groups", groups()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupsResponse, T> g) {
        return obj -> g.apply((DescribeGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGroupsResponse> {
        /**
         * <p>
         * The list of groups.
         * </p>
         * 
         * @param groups
         *        The list of groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupMetadata> groups);

        /**
         * <p>
         * The list of groups.
         * </p>
         * 
         * @param groups
         *        The list of groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupMetadata... groups);

        /**
         * <p>
         * The list of groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<GroupMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupMetadata>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<GroupMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<GroupMetadata>)
         */
        Builder groups(Consumer<GroupMetadata.Builder>... groups);

        /**
         * <p>
         * The marker to use when requesting the next set of results. If there are no additional results, the string is
         * empty.
         * </p>
         * 
         * @param marker
         *        The marker to use when requesting the next set of results. If there are no additional results, the
         *        string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private List<GroupMetadata> groups = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupsResponse model) {
            super(model);
            groups(model.groups);
            marker(model.marker);
        }

        public final Collection<GroupMetadata.Builder> getGroups() {
            return groups != null ? groups.stream().map(GroupMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupMetadata> groups) {
            this.groups = GroupMetadataListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupMetadata... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupMetadata.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupMetadata.BuilderImpl> groups) {
            this.groups = GroupMetadataListCopier.copyFromBuilder(groups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeGroupsResponse build() {
            return new DescribeGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
