/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGroupsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DescribeGroupsRequest> {
    private final String authenticationToken;
    private final String searchQuery;
    private final String organizationId;
    private final String marker;
    private final Integer limit;

    private DescribeGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.searchQuery = builder.searchQuery;
        this.organizationId = builder.organizationId;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String searchQuery() {
        return this.searchQuery;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String marker() {
        return this.marker;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupsRequest)) {
            return false;
        }
        DescribeGroupsRequest other = (DescribeGroupsRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.searchQuery(), other.searchQuery()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGroupsRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("SearchQuery", (Object)this.searchQuery()).add("OrganizationId", (Object)this.organizationId()).add("Marker", (Object)this.marker()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "SearchQuery": {
                return Optional.of(clazz.cast(this.searchQuery()));
            }
            case "OrganizationId": {
                return Optional.of(clazz.cast(this.organizationId()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String searchQuery;
        private String organizationId;
        private String marker;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupsRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.searchQuery(model.searchQuery);
            this.organizationId(model.organizationId);
            this.marker(model.marker);
            this.limit(model.limit);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getSearchQuery() {
            return this.searchQuery;
        }

        @Override
        public final Builder searchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public final void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeGroupsRequest build() {
            return new DescribeGroupsRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, DescribeGroupsRequest> {
        public Builder authenticationToken(String var1);

        public Builder searchQuery(String var1);

        public Builder organizationId(String var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

