/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.workdocs.model.SharedLabelsCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLabelsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, CreateLabelsRequest> {
    private final String resourceId;
    private final List<String> labels;
    private final String authenticationToken;

    private CreateLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.labels = builder.labels;
        this.authenticationToken = builder.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<String> labels() {
        return this.labels;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLabelsRequest)) {
            return false;
        }
        CreateLabelsRequest other = (CreateLabelsRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.authenticationToken(), other.authenticationToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateLabelsRequest").add("ResourceId", (Object)this.resourceId()).add("Labels", this.labels()).add("AuthenticationToken", (Object)this.authenticationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "Labels": {
                return Optional.of(clazz.cast(this.labels()));
            }
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private List<String> labels;
        private String authenticationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLabelsRequest model) {
            this.resourceId(model.resourceId);
            this.labels(model.labels);
            this.authenticationToken(model.authenticationToken);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLabelsRequest build() {
            return new CreateLabelsRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, CreateLabelsRequest> {
        public Builder resourceId(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder authenticationToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

