/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.PrincipalType;
import software.amazon.awssdk.services.workdocs.model.RoleType;
import software.amazon.awssdk.services.workdocs.transform.SharePrincipalMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SharePrincipal
implements StructuredPojo,
ToCopyableBuilder<Builder, SharePrincipal> {
    private final String id;
    private final String type;
    private final String role;

    private SharePrincipal(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.role = builder.role;
    }

    public String id() {
        return this.id;
    }

    public PrincipalType type() {
        return PrincipalType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public RoleType role() {
        return RoleType.fromValue(this.role);
    }

    public String roleString() {
        return this.role;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePrincipal)) {
            return false;
        }
        SharePrincipal other = (SharePrincipal)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.roleString(), other.roleString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.roleString() != null) {
            sb.append("Role: ").append(this.roleString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Role": {
                return Optional.of(clazz.cast(this.roleString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SharePrincipalMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(SharePrincipal model) {
            this.id(model.id);
            this.type(model.type);
            this.role(model.role);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PrincipalType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public SharePrincipal build() {
            return new SharePrincipal(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SharePrincipal> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(PrincipalType var1);

        public Builder role(String var1);

        public Builder role(RoleType var1);
    }
}

