/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.CommentStatusType;
import software.amazon.awssdk.services.workdocs.model.CommentVisibilityType;
import software.amazon.awssdk.services.workdocs.model.User;
import software.amazon.awssdk.services.workdocs.transform.CommentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Comment
implements StructuredPojo,
ToCopyableBuilder<Builder, Comment> {
    private final String commentId;
    private final String parentId;
    private final String threadId;
    private final String text;
    private final User contributor;
    private final Instant createdTimestamp;
    private final String status;
    private final String visibility;
    private final String recipientId;

    private Comment(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.parentId = builder.parentId;
        this.threadId = builder.threadId;
        this.text = builder.text;
        this.contributor = builder.contributor;
        this.createdTimestamp = builder.createdTimestamp;
        this.status = builder.status;
        this.visibility = builder.visibility;
        this.recipientId = builder.recipientId;
    }

    public String commentId() {
        return this.commentId;
    }

    public String parentId() {
        return this.parentId;
    }

    public String threadId() {
        return this.threadId;
    }

    public String text() {
        return this.text;
    }

    public User contributor() {
        return this.contributor;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public CommentStatusType status() {
        return CommentStatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public CommentVisibilityType visibility() {
        return CommentVisibilityType.fromValue(this.visibility);
    }

    public String visibilityString() {
        return this.visibility;
    }

    public String recipientId() {
        return this.recipientId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributor());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipientId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)obj;
        return Objects.equals(this.commentId(), other.commentId()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.threadId(), other.threadId()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.contributor(), other.contributor()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.visibilityString(), other.visibilityString()) && Objects.equals(this.recipientId(), other.recipientId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.commentId() != null) {
            sb.append("CommentId: ").append(this.commentId()).append(",");
        }
        if (this.parentId() != null) {
            sb.append("ParentId: ").append(this.parentId()).append(",");
        }
        if (this.threadId() != null) {
            sb.append("ThreadId: ").append(this.threadId()).append(",");
        }
        if (this.text() != null) {
            sb.append("Text: ").append(this.text()).append(",");
        }
        if (this.contributor() != null) {
            sb.append("Contributor: ").append(this.contributor()).append(",");
        }
        if (this.createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.createdTimestamp()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.visibilityString() != null) {
            sb.append("Visibility: ").append(this.visibilityString()).append(",");
        }
        if (this.recipientId() != null) {
            sb.append("RecipientId: ").append(this.recipientId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommentId": {
                return Optional.of(clazz.cast(this.commentId()));
            }
            case "ParentId": {
                return Optional.of(clazz.cast(this.parentId()));
            }
            case "ThreadId": {
                return Optional.of(clazz.cast(this.threadId()));
            }
            case "Text": {
                return Optional.of(clazz.cast(this.text()));
            }
            case "Contributor": {
                return Optional.of(clazz.cast(this.contributor()));
            }
            case "CreatedTimestamp": {
                return Optional.of(clazz.cast(this.createdTimestamp()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Visibility": {
                return Optional.of(clazz.cast(this.visibilityString()));
            }
            case "RecipientId": {
                return Optional.of(clazz.cast(this.recipientId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String commentId;
        private String parentId;
        private String threadId;
        private String text;
        private User contributor;
        private Instant createdTimestamp;
        private String status;
        private String visibility;
        private String recipientId;

        private BuilderImpl() {
        }

        private BuilderImpl(Comment model) {
            this.commentId(model.commentId);
            this.parentId(model.parentId);
            this.threadId(model.threadId);
            this.text(model.text);
            this.contributor(model.contributor);
            this.createdTimestamp(model.createdTimestamp);
            this.status(model.status);
            this.visibility(model.visibility);
            this.recipientId(model.recipientId);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getThreadId() {
            return this.threadId;
        }

        @Override
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final User.Builder getContributor() {
            return this.contributor != null ? this.contributor.toBuilder() : null;
        }

        @Override
        public final Builder contributor(User contributor) {
            this.contributor = contributor;
            return this;
        }

        public final void setContributor(User.BuilderImpl contributor) {
            this.contributor = contributor != null ? contributor.build() : null;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommentStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(CommentVisibilityType visibility) {
            this.visibility(visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final String getRecipientId() {
            return this.recipientId;
        }

        @Override
        public final Builder recipientId(String recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        public final void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public Comment build() {
            return new Comment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Comment> {
        public Builder commentId(String var1);

        public Builder parentId(String var1);

        public Builder threadId(String var1);

        public Builder text(String var1);

        public Builder contributor(User var1);

        default public Builder contributor(Consumer<User.Builder> contributor) {
            return this.contributor((User)((User.Builder)User.builder().apply(contributor)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(CommentStatusType var1);

        public Builder visibility(String var1);

        public Builder visibility(CommentVisibilityType var1);

        public Builder recipientId(String var1);
    }
}

