/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDocumentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetDocumentRequest> {
    private final String authenticationToken;
    private final String documentId;
    private final Boolean includeCustomMetadata;

    private GetDocumentRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.includeCustomMetadata = builder.includeCustomMetadata;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String documentId() {
        return this.documentId;
    }

    public Boolean includeCustomMetadata() {
        return this.includeCustomMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeCustomMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentRequest)) {
            return false;
        }
        GetDocumentRequest other = (GetDocumentRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.includeCustomMetadata(), other.includeCustomMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.documentId() != null) {
            sb.append("DocumentId: ").append(this.documentId()).append(",");
        }
        if (this.includeCustomMetadata() != null) {
            sb.append("IncludeCustomMetadata: ").append(this.includeCustomMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "DocumentId": {
                return Optional.of(clazz.cast(this.documentId()));
            }
            case "IncludeCustomMetadata": {
                return Optional.of(clazz.cast(this.includeCustomMetadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private Boolean includeCustomMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.documentId(model.documentId);
            this.includeCustomMetadata(model.includeCustomMetadata);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final Boolean getIncludeCustomMetadata() {
            return this.includeCustomMetadata;
        }

        @Override
        public final Builder includeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
            return this;
        }

        public final void setIncludeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
        }

        public GetDocumentRequest build() {
            return new GetDocumentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDocumentRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder includeCustomMetadata(Boolean var1);
    }
}

