/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.GroupMetadata;
import software.amazon.awssdk.services.workdocs.model.GroupMetadataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeGroupsResponse> {
    private final List<GroupMetadata> groups;
    private final String marker;

    private DescribeGroupsResponse(BuilderImpl builder) {
        this.groups = builder.groups;
        this.marker = builder.marker;
    }

    public List<GroupMetadata> groups() {
        return this.groups;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupsResponse)) {
            return false;
        }
        DescribeGroupsResponse other = (DescribeGroupsResponse)((Object)obj);
        return Objects.equals(this.groups(), other.groups()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<GroupMetadata> groups;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupsResponse model) {
            this.groups(model.groups);
            this.marker(model.marker);
        }

        public final Collection<GroupMetadata.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupMetadata> groups) {
            this.groups = GroupMetadataListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupMetadata ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupMetadata.BuilderImpl> groups) {
            this.groups = GroupMetadataListCopier.copyFromBuilder(groups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeGroupsResponse build() {
            return new DescribeGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeGroupsResponse> {
        public Builder groups(Collection<GroupMetadata> var1);

        public Builder groups(GroupMetadata ... var1);

        public Builder marker(String var1);
    }
}

