/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType;
import software.amazon.awssdk.services.workdocs.model.SubscriptionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateNotificationSubscriptionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateNotificationSubscriptionRequest> {
    private final String organizationId;
    private final String endpoint;
    private final String protocol;
    private final String subscriptionType;

    private CreateNotificationSubscriptionRequest(BuilderImpl builder) {
        this.organizationId = builder.organizationId;
        this.endpoint = builder.endpoint;
        this.protocol = builder.protocol;
        this.subscriptionType = builder.subscriptionType;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public SubscriptionProtocolType protocol() {
        return SubscriptionProtocolType.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(this.subscriptionType);
    }

    public String subscriptionTypeString() {
        return this.subscriptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationSubscriptionRequest)) {
            return false;
        }
        CreateNotificationSubscriptionRequest other = (CreateNotificationSubscriptionRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.protocolString(), other.protocolString()) && Objects.equals(this.subscriptionTypeString(), other.subscriptionTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.organizationId() != null) {
            sb.append("OrganizationId: ").append(this.organizationId()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.protocolString() != null) {
            sb.append("Protocol: ").append(this.protocolString()).append(",");
        }
        if (this.subscriptionTypeString() != null) {
            sb.append("SubscriptionType: ").append(this.subscriptionTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.of(clazz.cast(this.organizationId()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
            case "SubscriptionType": {
                return Optional.of(clazz.cast(this.subscriptionTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationId;
        private String endpoint;
        private String protocol;
        private String subscriptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationSubscriptionRequest model) {
            this.organizationId(model.organizationId);
            this.endpoint(model.endpoint);
            this.protocol(model.protocol);
            this.subscriptionType(model.subscriptionType);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(SubscriptionProtocolType protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public CreateNotificationSubscriptionRequest build() {
            return new CreateNotificationSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateNotificationSubscriptionRequest> {
        public Builder organizationId(String var1);

        public Builder endpoint(String var1);

        public Builder protocol(String var1);

        public Builder protocol(SubscriptionProtocolType var1);

        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);
    }
}

