/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCustomMetadataRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateCustomMetadataRequest> {
    private final String authenticationToken;
    private final String resourceId;
    private final String versionId;
    private final Map<String, String> customMetadata;

    private CreateCustomMetadataRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.versionId = builder.versionId;
        this.customMetadata = builder.customMetadata;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String versionId() {
        return this.versionId;
    }

    public Map<String, String> customMetadata() {
        return this.customMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomMetadataRequest)) {
            return false;
        }
        CreateCustomMetadataRequest other = (CreateCustomMetadataRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.customMetadata(), other.customMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.customMetadata() != null) {
            sb.append("CustomMetadata: ").append(this.customMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "CustomMetadata": {
                return Optional.of(clazz.cast(this.customMetadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String resourceId;
        private String versionId;
        private Map<String, String> customMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomMetadataRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.resourceId(model.resourceId);
            this.versionId(model.versionId);
            this.customMetadata(model.customMetadata);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Map<String, String> getCustomMetadata() {
            return this.customMetadata;
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        public CreateCustomMetadataRequest build() {
            return new CreateCustomMetadataRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateCustomMetadataRequest> {
        public Builder authenticationToken(String var1);

        public Builder resourceId(String var1);

        public Builder versionId(String var1);

        public Builder customMetadata(Map<String, String> var1);
    }
}

