/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType;
import software.amazon.awssdk.services.workdocs.transform.SubscriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subscription
implements StructuredPojo,
ToCopyableBuilder<Builder, Subscription> {
    private final String subscriptionId;
    private final String endPoint;
    private final String protocol;

    private Subscription(BuilderImpl builder) {
        this.subscriptionId = builder.subscriptionId;
        this.endPoint = builder.endPoint;
        this.protocol = builder.protocol;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String endPoint() {
        return this.endPoint;
    }

    public SubscriptionProtocolType protocol() {
        return SubscriptionProtocolType.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptionId() == null ? 0 : this.subscriptionId().hashCode());
        hashCode = 31 * hashCode + (this.endPoint() == null ? 0 : this.endPoint().hashCode());
        hashCode = 31 * hashCode + (this.protocolString() == null ? 0 : this.protocolString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        if (other.subscriptionId() == null ^ this.subscriptionId() == null) {
            return false;
        }
        if (other.subscriptionId() != null && !other.subscriptionId().equals(this.subscriptionId())) {
            return false;
        }
        if (other.endPoint() == null ^ this.endPoint() == null) {
            return false;
        }
        if (other.endPoint() != null && !other.endPoint().equals(this.endPoint())) {
            return false;
        }
        if (other.protocolString() == null ^ this.protocolString() == null) {
            return false;
        }
        return other.protocolString() == null || other.protocolString().equals(this.protocolString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subscriptionId() != null) {
            sb.append("SubscriptionId: ").append(this.subscriptionId()).append(",");
        }
        if (this.endPoint() != null) {
            sb.append("EndPoint: ").append(this.endPoint()).append(",");
        }
        if (this.protocolString() != null) {
            sb.append("Protocol: ").append(this.protocolString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionId": {
                return Optional.of(clazz.cast(this.subscriptionId()));
            }
            case "EndPoint": {
                return Optional.of(clazz.cast(this.endPoint()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionId;
        private String endPoint;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.subscriptionId(model.subscriptionId);
            this.endPoint(model.endPoint);
            this.protocol(model.protocol);
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public final String getEndPoint() {
            return this.endPoint;
        }

        @Override
        public final Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public final void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(SubscriptionProtocolType protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public Subscription build() {
            return new Subscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subscription> {
        public Builder subscriptionId(String var1);

        public Builder endPoint(String var1);

        public Builder protocol(String var1);

        public Builder protocol(SubscriptionProtocolType var1);
    }
}

