/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDocumentVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDocumentVersionRequest> {
    private final String authenticationToken;
    private final String documentId;
    private final String versionId;
    private final String versionStatus;

    private UpdateDocumentVersionRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.versionId = builder.versionId;
        this.versionStatus = builder.versionStatus;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String documentId() {
        return this.documentId;
    }

    public String versionId() {
        return this.versionId;
    }

    public String versionStatus() {
        return this.versionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authenticationToken() == null ? 0 : this.authenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.documentId() == null ? 0 : this.documentId().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.versionStatus() == null ? 0 : this.versionStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentVersionRequest)) {
            return false;
        }
        UpdateDocumentVersionRequest other = (UpdateDocumentVersionRequest)((Object)obj);
        if (other.authenticationToken() == null ^ this.authenticationToken() == null) {
            return false;
        }
        if (other.authenticationToken() != null && !other.authenticationToken().equals(this.authenticationToken())) {
            return false;
        }
        if (other.documentId() == null ^ this.documentId() == null) {
            return false;
        }
        if (other.documentId() != null && !other.documentId().equals(this.documentId())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.versionStatus() == null ^ this.versionStatus() == null) {
            return false;
        }
        return other.versionStatus() == null || other.versionStatus().equals(this.versionStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.documentId() != null) {
            sb.append("DocumentId: ").append(this.documentId()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.versionStatus() != null) {
            sb.append("VersionStatus: ").append(this.versionStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private String versionId;
        private String versionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentVersionRequest model) {
            this.setAuthenticationToken(model.authenticationToken);
            this.setDocumentId(model.documentId);
            this.setVersionId(model.versionId);
            this.setVersionStatus(model.versionStatus);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getVersionStatus() {
            return this.versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(DocumentVersionStatus versionStatus) {
            this.versionStatus(versionStatus.toString());
            return this;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        public UpdateDocumentVersionRequest build() {
            return new UpdateDocumentVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDocumentVersionRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder versionId(String var1);

        public Builder versionStatus(String var1);

        public Builder versionStatus(DocumentVersionStatus var1);
    }
}

