/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.transform.DocumentVersionMetadataUnmarshaller;

public class DocumentMetadataUnmarshaller
implements Unmarshaller<DocumentMetadata, JsonUnmarshallerContext> {
    private static final DocumentMetadataUnmarshaller INSTANCE = new DocumentMetadataUnmarshaller();

    public DocumentMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentMetadata.Builder documentMetadataBuilder = DocumentMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    documentMetadataBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatorId", targetDepth)) {
                    context.nextToken();
                    documentMetadataBuilder.creatorId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ParentFolderId", targetDepth)) {
                    context.nextToken();
                    documentMetadataBuilder.parentFolderId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedTimestamp", targetDepth)) {
                    context.nextToken();
                    documentMetadataBuilder.createdTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ModifiedTimestamp", targetDepth)) {
                    context.nextToken();
                    documentMetadataBuilder.modifiedTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LatestVersionMetadata", targetDepth)) {
                    context.nextToken();
                    documentMetadataBuilder.latestVersionMetadata(DocumentVersionMetadataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ResourceState", targetDepth)) {
                    context.nextToken();
                    documentMetadataBuilder.resourceState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Labels", targetDepth)) {
                    context.nextToken();
                    documentMetadataBuilder.labels(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DocumentMetadata)documentMetadataBuilder.build();
    }

    public static DocumentMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

