/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.GroupMetadata;
import software.amazon.awssdk.services.workdocs.model.GroupMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.services.workdocs.model.UserMetadataListCopier;
import software.amazon.awssdk.services.workdocs.transform.ParticipantsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Participants
implements StructuredPojo,
ToCopyableBuilder<Builder, Participants> {
    private final List<UserMetadata> users;
    private final List<GroupMetadata> groups;

    private Participants(BuilderImpl builder) {
        this.users = builder.users;
        this.groups = builder.groups;
    }

    public List<UserMetadata> users() {
        return this.users;
    }

    public List<GroupMetadata> groups() {
        return this.groups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.users() == null ? 0 : this.users().hashCode());
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participants)) {
            return false;
        }
        Participants other = (Participants)obj;
        if (other.users() == null ^ this.users() == null) {
            return false;
        }
        if (other.users() != null && !other.users().equals(this.users())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        return other.groups() == null || other.groups().equals(this.groups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.users() != null) {
            sb.append("Users: ").append(this.users()).append(",");
        }
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParticipantsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<UserMetadata> users;
        private List<GroupMetadata> groups;

        private BuilderImpl() {
        }

        private BuilderImpl(Participants model) {
            this.setUsers(model.users);
            this.setGroups(model.groups);
        }

        public final Collection<UserMetadata> getUsers() {
            return this.users;
        }

        @Override
        public final Builder users(Collection<UserMetadata> users) {
            this.users = UserMetadataListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserMetadata ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        public final void setUsers(Collection<UserMetadata> users) {
            this.users = UserMetadataListCopier.copy(users);
        }

        public final Collection<GroupMetadata> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<GroupMetadata> groups) {
            this.groups = GroupMetadataListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupMetadata ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupMetadata> groups) {
            this.groups = GroupMetadataListCopier.copy(groups);
        }

        public Participants build() {
            return new Participants(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Participants> {
        public Builder users(Collection<UserMetadata> var1);

        public Builder users(UserMetadata ... var1);

        public Builder groups(Collection<GroupMetadata> var1);

        public Builder groups(GroupMetadata ... var1);
    }
}

