/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.CommentMetadata;

@SdkInternalApi
public class CommentMetadataMarshaller {
    private static final MarshallingInfo<String> COMMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommentId").build();
    private static final MarshallingInfo<StructuredPojo> CONTRIBUTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Contributor").build();
    private static final MarshallingInfo<Instant> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").build();
    private static final MarshallingInfo<String> COMMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommentStatus").build();
    private static final MarshallingInfo<String> RECIPIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecipientId").build();
    private static final CommentMetadataMarshaller instance = new CommentMetadataMarshaller();

    public static CommentMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(CommentMetadata commentMetadata, ProtocolMarshaller protocolMarshaller) {
        if (commentMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)commentMetadata.commentId(), COMMENTID_BINDING);
            protocolMarshaller.marshall((Object)commentMetadata.contributor(), CONTRIBUTOR_BINDING);
            protocolMarshaller.marshall((Object)commentMetadata.createdTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)commentMetadata.commentStatus(), COMMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)commentMetadata.recipientId(), RECIPIENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

