/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.workdocs.model.EntityIdListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EntityNotExistsException
extends WorkDocsException
implements ToCopyableBuilder<Builder, EntityNotExistsException> {
    private final List<String> entityIds;

    private EntityNotExistsException(BuilderImpl builder) {
        super(builder.message);
        this.entityIds = builder.entityIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<String> entityIds() {
        return this.entityIds;
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> entityIds;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityNotExistsException model) {
            this.setEntityIds(model.entityIds);
            this.message = model.getMessage();
        }

        public final Collection<String> getEntityIds() {
            return this.entityIds;
        }

        @Override
        public final Builder entityIds(Collection<String> entityIds) {
            this.entityIds = EntityIdListCopier.copy(entityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityIds(String ... entityIds) {
            this.entityIds(Arrays.asList(entityIds));
            return this;
        }

        @JsonProperty(value="EntityIds")
        public final void setEntityIds(Collection<String> entityIds) {
            this.entityIds = EntityIdListCopier.copy(entityIds);
        }

        @SafeVarargs
        public final void setEntityIds(String ... entityIds) {
            this.entityIds(Arrays.asList(entityIds));
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public EntityNotExistsException build() {
            return new EntityNotExistsException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EntityNotExistsException> {
        public Builder entityIds(Collection<String> var1);

        public Builder entityIds(String ... var1);

        public Builder message(String var1);
    }
}

