/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.Activity;
import software.amazon.awssdk.services.workdocs.model.UserActivitiesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeActivitiesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeActivitiesResponse> {
    private final List<Activity> userActivities;
    private final String marker;

    private DescribeActivitiesResponse(BuilderImpl builder) {
        this.userActivities = builder.userActivities;
        this.marker = builder.marker;
    }

    public List<Activity> userActivities() {
        return this.userActivities;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userActivities() == null ? 0 : this.userActivities().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivitiesResponse)) {
            return false;
        }
        DescribeActivitiesResponse other = (DescribeActivitiesResponse)((Object)obj);
        if (other.userActivities() == null ^ this.userActivities() == null) {
            return false;
        }
        if (other.userActivities() != null && !other.userActivities().equals(this.userActivities())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userActivities() != null) {
            sb.append("UserActivities: ").append(this.userActivities()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Activity> userActivities;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivitiesResponse model) {
            this.setUserActivities(model.userActivities);
            this.setMarker(model.marker);
        }

        public final Collection<Activity> getUserActivities() {
            return this.userActivities;
        }

        @Override
        public final Builder userActivities(Collection<Activity> userActivities) {
            this.userActivities = UserActivitiesCopier.copy(userActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userActivities(Activity ... userActivities) {
            this.userActivities(Arrays.asList(userActivities));
            return this;
        }

        public final void setUserActivities(Collection<Activity> userActivities) {
            this.userActivities = UserActivitiesCopier.copy(userActivities);
        }

        @SafeVarargs
        public final void setUserActivities(Activity ... userActivities) {
            this.userActivities(Arrays.asList(userActivities));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeActivitiesResponse build() {
            return new DescribeActivitiesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeActivitiesResponse> {
        public Builder userActivities(Collection<Activity> var1);

        public Builder userActivities(Activity ... var1);

        public Builder marker(String var1);
    }
}

