/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.CommentStatusType;
import software.amazon.awssdk.services.workdocs.model.User;
import software.amazon.awssdk.services.workdocs.transform.CommentMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CommentMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, CommentMetadata> {
    private final String commentId;
    private final User contributor;
    private final Instant createdTimestamp;
    private final String commentStatus;
    private final String recipientId;

    private CommentMetadata(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.contributor = builder.contributor;
        this.createdTimestamp = builder.createdTimestamp;
        this.commentStatus = builder.commentStatus;
        this.recipientId = builder.recipientId;
    }

    public String commentId() {
        return this.commentId;
    }

    public User contributor() {
        return this.contributor;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public String commentStatus() {
        return this.commentStatus;
    }

    public String recipientId() {
        return this.recipientId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.commentId() == null ? 0 : this.commentId().hashCode());
        hashCode = 31 * hashCode + (this.contributor() == null ? 0 : this.contributor().hashCode());
        hashCode = 31 * hashCode + (this.createdTimestamp() == null ? 0 : this.createdTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.commentStatus() == null ? 0 : this.commentStatus().hashCode());
        hashCode = 31 * hashCode + (this.recipientId() == null ? 0 : this.recipientId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommentMetadata)) {
            return false;
        }
        CommentMetadata other = (CommentMetadata)obj;
        if (other.commentId() == null ^ this.commentId() == null) {
            return false;
        }
        if (other.commentId() != null && !other.commentId().equals(this.commentId())) {
            return false;
        }
        if (other.contributor() == null ^ this.contributor() == null) {
            return false;
        }
        if (other.contributor() != null && !other.contributor().equals(this.contributor())) {
            return false;
        }
        if (other.createdTimestamp() == null ^ this.createdTimestamp() == null) {
            return false;
        }
        if (other.createdTimestamp() != null && !other.createdTimestamp().equals(this.createdTimestamp())) {
            return false;
        }
        if (other.commentStatus() == null ^ this.commentStatus() == null) {
            return false;
        }
        if (other.commentStatus() != null && !other.commentStatus().equals(this.commentStatus())) {
            return false;
        }
        if (other.recipientId() == null ^ this.recipientId() == null) {
            return false;
        }
        return other.recipientId() == null || other.recipientId().equals(this.recipientId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commentId() != null) {
            sb.append("CommentId: ").append(this.commentId()).append(",");
        }
        if (this.contributor() != null) {
            sb.append("Contributor: ").append(this.contributor()).append(",");
        }
        if (this.createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.createdTimestamp()).append(",");
        }
        if (this.commentStatus() != null) {
            sb.append("CommentStatus: ").append(this.commentStatus()).append(",");
        }
        if (this.recipientId() != null) {
            sb.append("RecipientId: ").append(this.recipientId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommentMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String commentId;
        private User contributor;
        private Instant createdTimestamp;
        private String commentStatus;
        private String recipientId;

        private BuilderImpl() {
        }

        private BuilderImpl(CommentMetadata model) {
            this.setCommentId(model.commentId);
            this.setContributor(model.contributor);
            this.setCreatedTimestamp(model.createdTimestamp);
            this.setCommentStatus(model.commentStatus);
            this.setRecipientId(model.recipientId);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final User getContributor() {
            return this.contributor;
        }

        @Override
        public final Builder contributor(User contributor) {
            this.contributor = contributor;
            return this;
        }

        public final void setContributor(User contributor) {
            this.contributor = contributor;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final String getCommentStatus() {
            return this.commentStatus;
        }

        @Override
        public final Builder commentStatus(String commentStatus) {
            this.commentStatus = commentStatus;
            return this;
        }

        @Override
        public final Builder commentStatus(CommentStatusType commentStatus) {
            this.commentStatus(commentStatus.toString());
            return this;
        }

        public final void setCommentStatus(String commentStatus) {
            this.commentStatus = commentStatus;
        }

        public final void setCommentStatus(CommentStatusType commentStatus) {
            this.commentStatus(commentStatus.toString());
        }

        public final String getRecipientId() {
            return this.recipientId;
        }

        @Override
        public final Builder recipientId(String recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        public final void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public CommentMetadata build() {
            return new CommentMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CommentMetadata> {
        public Builder commentId(String var1);

        public Builder contributor(User var1);

        public Builder createdTimestamp(Instant var1);

        public Builder commentStatus(String var1);

        public Builder commentStatus(CommentStatusType var1);

        public Builder recipientId(String var1);
    }
}

