/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.CommentStatusType;
import software.amazon.awssdk.services.workdocs.model.CommentVisibilityType;
import software.amazon.awssdk.services.workdocs.model.User;
import software.amazon.awssdk.services.workdocs.transform.CommentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Comment
implements StructuredPojo,
ToCopyableBuilder<Builder, Comment> {
    private final String commentId;
    private final String parentId;
    private final String threadId;
    private final String text;
    private final User contributor;
    private final Instant createdTimestamp;
    private final String status;
    private final String visibility;
    private final String recipientId;

    private Comment(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.parentId = builder.parentId;
        this.threadId = builder.threadId;
        this.text = builder.text;
        this.contributor = builder.contributor;
        this.createdTimestamp = builder.createdTimestamp;
        this.status = builder.status;
        this.visibility = builder.visibility;
        this.recipientId = builder.recipientId;
    }

    public String commentId() {
        return this.commentId;
    }

    public String parentId() {
        return this.parentId;
    }

    public String threadId() {
        return this.threadId;
    }

    public String text() {
        return this.text;
    }

    public User contributor() {
        return this.contributor;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public String status() {
        return this.status;
    }

    public String visibility() {
        return this.visibility;
    }

    public String recipientId() {
        return this.recipientId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.commentId() == null ? 0 : this.commentId().hashCode());
        hashCode = 31 * hashCode + (this.parentId() == null ? 0 : this.parentId().hashCode());
        hashCode = 31 * hashCode + (this.threadId() == null ? 0 : this.threadId().hashCode());
        hashCode = 31 * hashCode + (this.text() == null ? 0 : this.text().hashCode());
        hashCode = 31 * hashCode + (this.contributor() == null ? 0 : this.contributor().hashCode());
        hashCode = 31 * hashCode + (this.createdTimestamp() == null ? 0 : this.createdTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.visibility() == null ? 0 : this.visibility().hashCode());
        hashCode = 31 * hashCode + (this.recipientId() == null ? 0 : this.recipientId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)obj;
        if (other.commentId() == null ^ this.commentId() == null) {
            return false;
        }
        if (other.commentId() != null && !other.commentId().equals(this.commentId())) {
            return false;
        }
        if (other.parentId() == null ^ this.parentId() == null) {
            return false;
        }
        if (other.parentId() != null && !other.parentId().equals(this.parentId())) {
            return false;
        }
        if (other.threadId() == null ^ this.threadId() == null) {
            return false;
        }
        if (other.threadId() != null && !other.threadId().equals(this.threadId())) {
            return false;
        }
        if (other.text() == null ^ this.text() == null) {
            return false;
        }
        if (other.text() != null && !other.text().equals(this.text())) {
            return false;
        }
        if (other.contributor() == null ^ this.contributor() == null) {
            return false;
        }
        if (other.contributor() != null && !other.contributor().equals(this.contributor())) {
            return false;
        }
        if (other.createdTimestamp() == null ^ this.createdTimestamp() == null) {
            return false;
        }
        if (other.createdTimestamp() != null && !other.createdTimestamp().equals(this.createdTimestamp())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.visibility() == null ^ this.visibility() == null) {
            return false;
        }
        if (other.visibility() != null && !other.visibility().equals(this.visibility())) {
            return false;
        }
        if (other.recipientId() == null ^ this.recipientId() == null) {
            return false;
        }
        return other.recipientId() == null || other.recipientId().equals(this.recipientId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commentId() != null) {
            sb.append("CommentId: ").append(this.commentId()).append(",");
        }
        if (this.parentId() != null) {
            sb.append("ParentId: ").append(this.parentId()).append(",");
        }
        if (this.threadId() != null) {
            sb.append("ThreadId: ").append(this.threadId()).append(",");
        }
        if (this.text() != null) {
            sb.append("Text: ").append(this.text()).append(",");
        }
        if (this.contributor() != null) {
            sb.append("Contributor: ").append(this.contributor()).append(",");
        }
        if (this.createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.createdTimestamp()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.visibility() != null) {
            sb.append("Visibility: ").append(this.visibility()).append(",");
        }
        if (this.recipientId() != null) {
            sb.append("RecipientId: ").append(this.recipientId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String commentId;
        private String parentId;
        private String threadId;
        private String text;
        private User contributor;
        private Instant createdTimestamp;
        private String status;
        private String visibility;
        private String recipientId;

        private BuilderImpl() {
        }

        private BuilderImpl(Comment model) {
            this.setCommentId(model.commentId);
            this.setParentId(model.parentId);
            this.setThreadId(model.threadId);
            this.setText(model.text);
            this.setContributor(model.contributor);
            this.setCreatedTimestamp(model.createdTimestamp);
            this.setStatus(model.status);
            this.setVisibility(model.visibility);
            this.setRecipientId(model.recipientId);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getThreadId() {
            return this.threadId;
        }

        @Override
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final User getContributor() {
            return this.contributor;
        }

        @Override
        public final Builder contributor(User contributor) {
            this.contributor = contributor;
            return this;
        }

        public final void setContributor(User contributor) {
            this.contributor = contributor;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommentStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(CommentStatusType status) {
            this.status(status.toString());
        }

        public final String getVisibility() {
            return this.visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(CommentVisibilityType visibility) {
            this.visibility(visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final void setVisibility(CommentVisibilityType visibility) {
            this.visibility(visibility.toString());
        }

        public final String getRecipientId() {
            return this.recipientId;
        }

        @Override
        public final Builder recipientId(String recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        public final void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public Comment build() {
            return new Comment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Comment> {
        public Builder commentId(String var1);

        public Builder parentId(String var1);

        public Builder threadId(String var1);

        public Builder text(String var1);

        public Builder contributor(User var1);

        public Builder createdTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(CommentStatusType var1);

        public Builder visibility(String var1);

        public Builder visibility(CommentVisibilityType var1);

        public Builder recipientId(String var1);
    }
}

