/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.StorageRuleType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StorageRuleTypeMarshaller {
    private static final MarshallingInfo<Long> STORAGEALLOCATEDINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageAllocatedInBytes").isBinary(false).build();
    private static final MarshallingInfo<String> STORAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageType").isBinary(false).build();
    private static final StorageRuleTypeMarshaller INSTANCE = new StorageRuleTypeMarshaller();

    private StorageRuleTypeMarshaller() {
    }

    public static StorageRuleTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StorageRuleType storageRuleType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)storageRuleType, (String)"storageRuleType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)storageRuleType.storageAllocatedInBytes(), STORAGEALLOCATEDINBYTES_BINDING);
            protocolMarshaller.marshall((Object)storageRuleType.storageTypeAsString(), STORAGETYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

