/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateCustomMetadataRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("versionid").isBinary(false).build();
    private static final MarshallingInfo<Map> CUSTOMMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomMetadata").isBinary(false).build();
    private static final CreateCustomMetadataRequestModelMarshaller INSTANCE = new CreateCustomMetadataRequestModelMarshaller();

    private CreateCustomMetadataRequestModelMarshaller() {
    }

    public static CreateCustomMetadataRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateCustomMetadataRequest createCustomMetadataRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createCustomMetadataRequest), (String)"createCustomMetadataRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createCustomMetadataRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createCustomMetadataRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)createCustomMetadataRequest.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall(createCustomMetadataRequest.customMetadata(), CUSTOMMETADATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

