/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.RoleType;
import software.amazon.awssdk.services.workdocs.model.ShareStatusType;
import software.amazon.awssdk.services.workdocs.transform.ShareResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareResult
implements StructuredPojo,
ToCopyableBuilder<Builder, ShareResult> {
    private final String principalId;
    private final String role;
    private final String status;
    private final String shareId;
    private final String statusMessage;

    private ShareResult(BuilderImpl builder) {
        this.principalId = builder.principalId;
        this.role = builder.role;
        this.status = builder.status;
        this.shareId = builder.shareId;
        this.statusMessage = builder.statusMessage;
    }

    public String principalId() {
        return this.principalId;
    }

    public RoleType role() {
        return RoleType.fromValue(this.role);
    }

    public String roleAsString() {
        return this.role;
    }

    public ShareStatusType status() {
        return ShareStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String shareId() {
        return this.shareId;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareResult)) {
            return false;
        }
        ShareResult other = (ShareResult)obj;
        return Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.shareId(), other.shareId()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"ShareResult").add("PrincipalId", (Object)this.principalId()).add("Role", (Object)this.roleAsString()).add("Status", (Object)this.statusAsString()).add("ShareId", (Object)this.shareId()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ShareId": {
                return Optional.ofNullable(clazz.cast(this.shareId()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShareResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String principalId;
        private String role;
        private String status;
        private String shareId;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareResult model) {
            this.principalId(model.principalId);
            this.role(model.role);
            this.status(model.status);
            this.shareId(model.shareId);
            this.statusMessage(model.statusMessage);
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getShareId() {
            return this.shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ShareResult build() {
            return new ShareResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ShareResult> {
        public Builder principalId(String var1);

        public Builder role(String var1);

        public Builder role(RoleType var1);

        public Builder status(String var1);

        public Builder status(ShareStatusType var1);

        public Builder shareId(String var1);

        public Builder statusMessage(String var1);
    }
}

