/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.EntityIdListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityNotExistsException
extends WorkDocsException
implements ToCopyableBuilder<Builder, EntityNotExistsException> {
    private final List<String> entityIds;

    private EntityNotExistsException(BuilderImpl builder) {
        super(builder);
        this.entityIds = builder.entityIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<String> entityIds() {
        return this.entityIds;
    }

    static final class BuilderImpl
    extends WorkDocsException.BuilderImpl
    implements Builder {
        private List<String> entityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityNotExistsException model) {
            super(model);
            this.entityIds(model.entityIds);
        }

        public final Collection<String> getEntityIds() {
            return this.entityIds;
        }

        @Override
        public final Builder entityIds(Collection<String> entityIds) {
            this.entityIds = EntityIdListCopier.copy(entityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityIds(String ... entityIds) {
            this.entityIds(Arrays.asList(entityIds));
            return this;
        }

        @JsonProperty(value="EntityIds")
        public final void setEntityIds(Collection<String> entityIds) {
            this.entityIds = EntityIdListCopier.copy(entityIds);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public EntityNotExistsException build() {
            return new EntityNotExistsException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EntityNotExistsException>,
    WorkDocsException.Builder {
        public Builder entityIds(Collection<String> var1);

        public Builder entityIds(String ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

