/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.ResourcePath;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourcePathMarshaller {
    private static final MarshallingInfo<List> COMPONENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Components").isBinary(false).build();
    private static final ResourcePathMarshaller INSTANCE = new ResourcePathMarshaller();

    private ResourcePathMarshaller() {
    }

    public static ResourcePathMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourcePath resourcePath, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourcePath, (String)"resourcePath");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(resourcePath.components(), COMPONENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

