/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.ResourcePathComponent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourcePathComponentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final ResourcePathComponentMarshaller INSTANCE = new ResourcePathComponentMarshaller();

    private ResourcePathComponentMarshaller() {
    }

    public static ResourcePathComponentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourcePathComponent resourcePathComponent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourcePathComponent, (String)"resourcePathComponent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourcePathComponent.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)resourcePathComponent.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

