/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.CreateUserRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateUserRequestModelMarshaller {
    private static final MarshallingInfo<String> ORGANIZATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationId").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailAddress").isBinary(false).build();
    private static final MarshallingInfo<String> GIVENNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GivenName").isBinary(false).build();
    private static final MarshallingInfo<String> SURNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Surname").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEZONEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeZoneId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STORAGERULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageRule").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final CreateUserRequestModelMarshaller INSTANCE = new CreateUserRequestModelMarshaller();

    private CreateUserRequestModelMarshaller() {
    }

    public static CreateUserRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateUserRequest createUserRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createUserRequest), (String)"createUserRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createUserRequest.organizationId(), ORGANIZATIONID_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.emailAddress(), EMAILADDRESS_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.givenName(), GIVENNAME_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.surname(), SURNAME_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.timeZoneId(), TIMEZONEID_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.storageRule(), STORAGERULE_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

