/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;

public class DescribeDocumentVersionsPublisher
implements SdkPublisher<DescribeDocumentVersionsResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeDocumentVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDocumentVersionsPublisher(WorkDocsAsyncClient client, DescribeDocumentVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDocumentVersionsPublisher(WorkDocsAsyncClient client, DescribeDocumentVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDocumentVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDocumentVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DocumentVersionMetadata> documentVersions() {
        Function<DescribeDocumentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentVersions() != null) {
                return response.documentVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDocumentVersionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDocumentVersionsPublisher resume(DescribeDocumentVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDocumentVersionsPublisher(this.client, (DescribeDocumentVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDocumentVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDocumentVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDocumentVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeDocumentVersionsResponse> {
        private DescribeDocumentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDocumentVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDocumentVersionsResponse> nextPage(DescribeDocumentVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDocumentVersionsPublisher.this.client.describeDocumentVersions(DescribeDocumentVersionsPublisher.this.firstRequest);
            }
            return DescribeDocumentVersionsPublisher.this.client.describeDocumentVersions((DescribeDocumentVersionsRequest)((Object)DescribeDocumentVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

