/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;

public class DescribeDocumentVersionsIterable
implements SdkIterable<DescribeDocumentVersionsResponse> {
    private final WorkDocsClient client;
    private final DescribeDocumentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDocumentVersionsIterable(WorkDocsClient client, DescribeDocumentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDocumentVersionsResponseFetcher();
    }

    public Iterator<DescribeDocumentVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DocumentVersionMetadata> documentVersions() {
        Function<DescribeDocumentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentVersions() != null) {
                return response.documentVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDocumentVersionsIterable resume(DescribeDocumentVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDocumentVersionsIterable(this.client, (DescribeDocumentVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDocumentVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDocumentVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDocumentVersionsResponseFetcher
    implements SyncPageFetcher<DescribeDocumentVersionsResponse> {
        private DescribeDocumentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDocumentVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDocumentVersionsResponse nextPage(DescribeDocumentVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDocumentVersionsIterable.this.client.describeDocumentVersions(DescribeDocumentVersionsIterable.this.firstRequest);
            }
            return DescribeDocumentVersionsIterable.this.client.describeDocumentVersions((DescribeDocumentVersionsRequest)((Object)DescribeDocumentVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

